/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.operatoraccesscontrol.model.ReviewAccessRequestDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReviewAccessRequestRequest
extends BmcRequest<ReviewAccessRequestDetails> {
    private String accessRequestId;
    private ReviewAccessRequestDetails reviewAccessRequestDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getAccessRequestId() {
        return this.accessRequestId;
    }

    public ReviewAccessRequestDetails getReviewAccessRequestDetails() {
        return this.reviewAccessRequestDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ReviewAccessRequestDetails getBody$() {
        return this.reviewAccessRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().accessRequestId(this.accessRequestId).reviewAccessRequestDetails(this.reviewAccessRequestDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",accessRequestId=").append(String.valueOf(this.accessRequestId));
        sb.append(",reviewAccessRequestDetails=").append(String.valueOf((Object)this.reviewAccessRequestDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReviewAccessRequestRequest)) {
            return false;
        }
        ReviewAccessRequestRequest other = (ReviewAccessRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.accessRequestId, other.accessRequestId) && Objects.equals((Object)this.reviewAccessRequestDetails, (Object)other.reviewAccessRequestDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessRequestId == null ? 43 : this.accessRequestId.hashCode());
        result = result * 59 + (this.reviewAccessRequestDetails == null ? 43 : this.reviewAccessRequestDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReviewAccessRequestRequest, ReviewAccessRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String accessRequestId = null;
        private ReviewAccessRequestDetails reviewAccessRequestDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder accessRequestId(String accessRequestId) {
            this.accessRequestId = accessRequestId;
            return this;
        }

        public Builder reviewAccessRequestDetails(ReviewAccessRequestDetails reviewAccessRequestDetails) {
            this.reviewAccessRequestDetails = reviewAccessRequestDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReviewAccessRequestRequest o) {
            this.accessRequestId(o.getAccessRequestId());
            this.reviewAccessRequestDetails(o.getReviewAccessRequestDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReviewAccessRequestRequest build() {
            ReviewAccessRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ReviewAccessRequestDetails body) {
            this.reviewAccessRequestDetails(body);
            return this;
        }

        public ReviewAccessRequestRequest buildWithoutInvocationCallback() {
            ReviewAccessRequestRequest request = new ReviewAccessRequestRequest();
            request.accessRequestId = this.accessRequestId;
            request.reviewAccessRequestDetails = this.reviewAccessRequestDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

