/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.operatoraccesscontrol.model.InteractionRequestDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class InteractionRequestRequest
extends BmcRequest<InteractionRequestDetails> {
    private String accessRequestId;
    private InteractionRequestDetails interactionRequestDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getAccessRequestId() {
        return this.accessRequestId;
    }

    public InteractionRequestDetails getInteractionRequestDetails() {
        return this.interactionRequestDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public InteractionRequestDetails getBody$() {
        return this.interactionRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().accessRequestId(this.accessRequestId).interactionRequestDetails(this.interactionRequestDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",accessRequestId=").append(String.valueOf(this.accessRequestId));
        sb.append(",interactionRequestDetails=").append(String.valueOf((Object)this.interactionRequestDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InteractionRequestRequest)) {
            return false;
        }
        InteractionRequestRequest other = (InteractionRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.accessRequestId, other.accessRequestId) && Objects.equals((Object)this.interactionRequestDetails, (Object)other.interactionRequestDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessRequestId == null ? 43 : this.accessRequestId.hashCode());
        result = result * 59 + (this.interactionRequestDetails == null ? 43 : this.interactionRequestDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<InteractionRequestRequest, InteractionRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String accessRequestId = null;
        private InteractionRequestDetails interactionRequestDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder accessRequestId(String accessRequestId) {
            this.accessRequestId = accessRequestId;
            return this;
        }

        public Builder interactionRequestDetails(InteractionRequestDetails interactionRequestDetails) {
            this.interactionRequestDetails = interactionRequestDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InteractionRequestRequest o) {
            this.accessRequestId(o.getAccessRequestId());
            this.interactionRequestDetails(o.getInteractionRequestDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InteractionRequestRequest build() {
            InteractionRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InteractionRequestDetails body) {
            this.interactionRequestDetails(body);
            return this;
        }

        public InteractionRequestRequest buildWithoutInvocationCallback() {
            InteractionRequestRequest request = new InteractionRequestRequest();
            request.accessRequestId = this.accessRequestId;
            request.interactionRequestDetails = this.interactionRequestDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

