/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOperatorControlRequest
extends BmcRequest<Void> {
    private String operatorControlId;
    private String opcRequestId;

    public String getOperatorControlId() {
        return this.operatorControlId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().operatorControlId(this.operatorControlId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",operatorControlId=").append(String.valueOf(this.operatorControlId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOperatorControlRequest)) {
            return false;
        }
        GetOperatorControlRequest other = (GetOperatorControlRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.operatorControlId, other.operatorControlId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.operatorControlId == null ? 43 : this.operatorControlId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOperatorControlRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String operatorControlId = null;
        private String opcRequestId = null;

        public Builder operatorControlId(String operatorControlId) {
            this.operatorControlId = operatorControlId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOperatorControlRequest o) {
            this.operatorControlId(o.getOperatorControlId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOperatorControlRequest build() {
            GetOperatorControlRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOperatorControlRequest buildWithoutInvocationCallback() {
            GetOperatorControlRequest request = new GetOperatorControlRequest();
            request.operatorControlId = this.operatorControlId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

