/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOperatorControlAssignmentRequest
extends BmcRequest<Void> {
    private String operatorControlAssignmentId;
    private String opcRequestId;

    public String getOperatorControlAssignmentId() {
        return this.operatorControlAssignmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().operatorControlAssignmentId(this.operatorControlAssignmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",operatorControlAssignmentId=").append(String.valueOf(this.operatorControlAssignmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOperatorControlAssignmentRequest)) {
            return false;
        }
        GetOperatorControlAssignmentRequest other = (GetOperatorControlAssignmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.operatorControlAssignmentId, other.operatorControlAssignmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.operatorControlAssignmentId == null ? 43 : this.operatorControlAssignmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOperatorControlAssignmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String operatorControlAssignmentId = null;
        private String opcRequestId = null;

        public Builder operatorControlAssignmentId(String operatorControlAssignmentId) {
            this.operatorControlAssignmentId = operatorControlAssignmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOperatorControlAssignmentRequest o) {
            this.operatorControlAssignmentId(o.getOperatorControlAssignmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOperatorControlAssignmentRequest build() {
            GetOperatorControlAssignmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOperatorControlAssignmentRequest buildWithoutInvocationCallback() {
            GetOperatorControlAssignmentRequest request = new GetOperatorControlAssignmentRequest();
            request.operatorControlAssignmentId = this.operatorControlAssignmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

