/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteOperatorControlAssignmentRequest
extends BmcRequest<Void> {
    private String operatorControlAssignmentId;
    private String description;
    private String ifMatch;
    private String opcRequestId;

    public String getOperatorControlAssignmentId() {
        return this.operatorControlAssignmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().operatorControlAssignmentId(this.operatorControlAssignmentId).description(this.description).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",operatorControlAssignmentId=").append(String.valueOf(this.operatorControlAssignmentId));
        sb.append(",description=").append(String.valueOf(this.description));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteOperatorControlAssignmentRequest)) {
            return false;
        }
        DeleteOperatorControlAssignmentRequest other = (DeleteOperatorControlAssignmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.operatorControlAssignmentId, other.operatorControlAssignmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.operatorControlAssignmentId == null ? 43 : this.operatorControlAssignmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteOperatorControlAssignmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String operatorControlAssignmentId = null;
        private String description = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder operatorControlAssignmentId(String operatorControlAssignmentId) {
            this.operatorControlAssignmentId = operatorControlAssignmentId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteOperatorControlAssignmentRequest o) {
            this.operatorControlAssignmentId(o.getOperatorControlAssignmentId());
            this.description(o.getDescription());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteOperatorControlAssignmentRequest build() {
            DeleteOperatorControlAssignmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteOperatorControlAssignmentRequest buildWithoutInvocationCallback() {
            DeleteOperatorControlAssignmentRequest request = new DeleteOperatorControlAssignmentRequest();
            request.operatorControlAssignmentId = this.operatorControlAssignmentId;
            request.description = this.description;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

