/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.operatoraccesscontrol.model.ApproveAccessRequestDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ApproveAccessRequestRequest
extends BmcRequest<ApproveAccessRequestDetails> {
    private String accessRequestId;
    private ApproveAccessRequestDetails approveAccessRequestDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getAccessRequestId() {
        return this.accessRequestId;
    }

    public ApproveAccessRequestDetails getApproveAccessRequestDetails() {
        return this.approveAccessRequestDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ApproveAccessRequestDetails getBody$() {
        return this.approveAccessRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().accessRequestId(this.accessRequestId).approveAccessRequestDetails(this.approveAccessRequestDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",accessRequestId=").append(String.valueOf(this.accessRequestId));
        sb.append(",approveAccessRequestDetails=").append(String.valueOf((Object)this.approveAccessRequestDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApproveAccessRequestRequest)) {
            return false;
        }
        ApproveAccessRequestRequest other = (ApproveAccessRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.accessRequestId, other.accessRequestId) && Objects.equals((Object)this.approveAccessRequestDetails, (Object)other.approveAccessRequestDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessRequestId == null ? 43 : this.accessRequestId.hashCode());
        result = result * 59 + (this.approveAccessRequestDetails == null ? 43 : this.approveAccessRequestDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ApproveAccessRequestRequest, ApproveAccessRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String accessRequestId = null;
        private ApproveAccessRequestDetails approveAccessRequestDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder accessRequestId(String accessRequestId) {
            this.accessRequestId = accessRequestId;
            return this;
        }

        public Builder approveAccessRequestDetails(ApproveAccessRequestDetails approveAccessRequestDetails) {
            this.approveAccessRequestDetails = approveAccessRequestDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ApproveAccessRequestRequest o) {
            this.accessRequestId(o.getAccessRequestId());
            this.approveAccessRequestDetails(o.getApproveAccessRequestDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ApproveAccessRequestRequest build() {
            ApproveAccessRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ApproveAccessRequestDetails body) {
            this.approveAccessRequestDetails(body);
            return this;
        }

        public ApproveAccessRequestRequest buildWithoutInvocationCallback() {
            ApproveAccessRequestRequest request = new ApproveAccessRequestRequest();
            request.accessRequestId = this.accessRequestId;
            request.approveAccessRequestDetails = this.approveAccessRequestDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

