/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlLifecycleStates;
import com.oracle.bmc.operatoraccesscontrol.model.ResourceTypes;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OperatorControlSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="operatorControlName")
    private final String operatorControlName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isFullyPreApproved")
    private final Boolean isFullyPreApproved;
    @JsonProperty(value="resourceType")
    private final ResourceTypes resourceType;
    @JsonProperty(value="timeOfCreation")
    private final Date timeOfCreation;
    @JsonProperty(value="timeOfModification")
    private final Date timeOfModification;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="lifecycleState")
    private final OperatorControlLifecycleStates lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "operatorControlName", "compartmentId", "isFullyPreApproved", "resourceType", "timeOfCreation", "timeOfModification", "timeOfDeletion", "lifecycleState", "freeformTags", "definedTags"})
    public OperatorControlSummary(String id, String operatorControlName, String compartmentId, Boolean isFullyPreApproved, ResourceTypes resourceType, Date timeOfCreation, Date timeOfModification, Date timeOfDeletion, OperatorControlLifecycleStates lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.operatorControlName = operatorControlName;
        this.compartmentId = compartmentId;
        this.isFullyPreApproved = isFullyPreApproved;
        this.resourceType = resourceType;
        this.timeOfCreation = timeOfCreation;
        this.timeOfModification = timeOfModification;
        this.timeOfDeletion = timeOfDeletion;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getOperatorControlName() {
        return this.operatorControlName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsFullyPreApproved() {
        return this.isFullyPreApproved;
    }

    public ResourceTypes getResourceType() {
        return this.resourceType;
    }

    public Date getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public Date getTimeOfModification() {
        return this.timeOfModification;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public OperatorControlLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OperatorControlSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", operatorControlName=").append(String.valueOf(this.operatorControlName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isFullyPreApproved=").append(String.valueOf(this.isFullyPreApproved));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", timeOfCreation=").append(String.valueOf(this.timeOfCreation));
        sb.append(", timeOfModification=").append(String.valueOf(this.timeOfModification));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorControlSummary)) {
            return false;
        }
        OperatorControlSummary other = (OperatorControlSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.operatorControlName, other.operatorControlName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isFullyPreApproved, other.isFullyPreApproved) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.timeOfCreation, other.timeOfCreation) && Objects.equals(this.timeOfModification, other.timeOfModification) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.operatorControlName == null ? 43 : this.operatorControlName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isFullyPreApproved == null ? 43 : this.isFullyPreApproved.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.timeOfCreation == null ? 43 : this.timeOfCreation.hashCode());
        result = result * 59 + (this.timeOfModification == null ? 43 : this.timeOfModification.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="operatorControlName")
        private String operatorControlName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isFullyPreApproved")
        private Boolean isFullyPreApproved;
        @JsonProperty(value="resourceType")
        private ResourceTypes resourceType;
        @JsonProperty(value="timeOfCreation")
        private Date timeOfCreation;
        @JsonProperty(value="timeOfModification")
        private Date timeOfModification;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="lifecycleState")
        private OperatorControlLifecycleStates lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder operatorControlName(String operatorControlName) {
            this.operatorControlName = operatorControlName;
            this.__explicitlySet__.add("operatorControlName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isFullyPreApproved(Boolean isFullyPreApproved) {
            this.isFullyPreApproved = isFullyPreApproved;
            this.__explicitlySet__.add("isFullyPreApproved");
            return this;
        }

        public Builder resourceType(ResourceTypes resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder timeOfCreation(Date timeOfCreation) {
            this.timeOfCreation = timeOfCreation;
            this.__explicitlySet__.add("timeOfCreation");
            return this;
        }

        public Builder timeOfModification(Date timeOfModification) {
            this.timeOfModification = timeOfModification;
            this.__explicitlySet__.add("timeOfModification");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder lifecycleState(OperatorControlLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public OperatorControlSummary build() {
            OperatorControlSummary model = new OperatorControlSummary(this.id, this.operatorControlName, this.compartmentId, this.isFullyPreApproved, this.resourceType, this.timeOfCreation, this.timeOfModification, this.timeOfDeletion, this.lifecycleState, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OperatorControlSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("operatorControlName")) {
                this.operatorControlName(model.getOperatorControlName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isFullyPreApproved")) {
                this.isFullyPreApproved(model.getIsFullyPreApproved());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("timeOfCreation")) {
                this.timeOfCreation(model.getTimeOfCreation());
            }
            if (model.wasPropertyExplicitlySet("timeOfModification")) {
                this.timeOfModification(model.getTimeOfModification());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

