/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InteractionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="userType")
    private final String userType;
    @JsonProperty(value="timeOfConversation")
    private final Date timeOfConversation;

    @Deprecated
    @ConstructorProperties(value={"id", "userId", "userName", "message", "userType", "timeOfConversation"})
    public InteractionSummary(String id, String userId, String userName, String message, String userType, Date timeOfConversation) {
        this.id = id;
        this.userId = userId;
        this.userName = userName;
        this.message = message;
        this.userType = userType;
        this.timeOfConversation = timeOfConversation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserType() {
        return this.userType;
    }

    public Date getTimeOfConversation() {
        return this.timeOfConversation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InteractionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", userId=").append(String.valueOf(this.userId));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", userType=").append(String.valueOf(this.userType));
        sb.append(", timeOfConversation=").append(String.valueOf(this.timeOfConversation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InteractionSummary)) {
            return false;
        }
        InteractionSummary other = (InteractionSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.userId, other.userId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.message, other.message) && Objects.equals(this.userType, other.userType) && Objects.equals(this.timeOfConversation, other.timeOfConversation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.userType == null ? 43 : this.userType.hashCode());
        result = result * 59 + (this.timeOfConversation == null ? 43 : this.timeOfConversation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="userType")
        private String userType;
        @JsonProperty(value="timeOfConversation")
        private Date timeOfConversation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            this.__explicitlySet__.add("userType");
            return this;
        }

        public Builder timeOfConversation(Date timeOfConversation) {
            this.timeOfConversation = timeOfConversation;
            this.__explicitlySet__.add("timeOfConversation");
            return this;
        }

        public InteractionSummary build() {
            InteractionSummary model = new InteractionSummary(this.id, this.userId, this.userName, this.message, this.userType, this.timeOfConversation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InteractionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("userType")) {
                this.userType(model.getUserType());
            }
            if (model.wasPropertyExplicitlySet("timeOfConversation")) {
                this.timeOfConversation(model.getTimeOfConversation());
            }
            return this;
        }
    }
}

