/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestLifecycleStates;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessRequestHistorySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lifecycleState")
    private final AccessRequestLifecycleStates lifecycleState;
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="duration")
    private final Integer duration;
    @JsonProperty(value="isAutoApproved")
    private final Boolean isAutoApproved;
    @JsonProperty(value="actionsList")
    private final List<String> actionsList;
    @JsonProperty(value="timeOfAction")
    private final Date timeOfAction;

    @Deprecated
    @ConstructorProperties(value={"lifecycleState", "userId", "description", "duration", "isAutoApproved", "actionsList", "timeOfAction"})
    public AccessRequestHistorySummary(AccessRequestLifecycleStates lifecycleState, String userId, String description, Integer duration, Boolean isAutoApproved, List<String> actionsList, Date timeOfAction) {
        this.lifecycleState = lifecycleState;
        this.userId = userId;
        this.description = description;
        this.duration = duration;
        this.isAutoApproved = isAutoApproved;
        this.actionsList = actionsList;
        this.timeOfAction = timeOfAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AccessRequestLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Boolean getIsAutoApproved() {
        return this.isAutoApproved;
    }

    public List<String> getActionsList() {
        return this.actionsList;
    }

    public Date getTimeOfAction() {
        return this.timeOfAction;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessRequestHistorySummary(");
        sb.append("super=").append(super.toString());
        sb.append("lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", userId=").append(String.valueOf(this.userId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(", isAutoApproved=").append(String.valueOf(this.isAutoApproved));
        sb.append(", actionsList=").append(String.valueOf(this.actionsList));
        sb.append(", timeOfAction=").append(String.valueOf(this.timeOfAction));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessRequestHistorySummary)) {
            return false;
        }
        AccessRequestHistorySummary other = (AccessRequestHistorySummary)((Object)o);
        return Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.userId, other.userId) && Objects.equals(this.description, other.description) && Objects.equals(this.duration, other.duration) && Objects.equals(this.isAutoApproved, other.isAutoApproved) && Objects.equals(this.actionsList, other.actionsList) && Objects.equals(this.timeOfAction, other.timeOfAction) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + (this.isAutoApproved == null ? 43 : this.isAutoApproved.hashCode());
        result = result * 59 + (this.actionsList == null ? 43 : this.actionsList.hashCode());
        result = result * 59 + (this.timeOfAction == null ? 43 : this.timeOfAction.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private AccessRequestLifecycleStates lifecycleState;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="duration")
        private Integer duration;
        @JsonProperty(value="isAutoApproved")
        private Boolean isAutoApproved;
        @JsonProperty(value="actionsList")
        private List<String> actionsList;
        @JsonProperty(value="timeOfAction")
        private Date timeOfAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(AccessRequestLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Builder isAutoApproved(Boolean isAutoApproved) {
            this.isAutoApproved = isAutoApproved;
            this.__explicitlySet__.add("isAutoApproved");
            return this;
        }

        public Builder actionsList(List<String> actionsList) {
            this.actionsList = actionsList;
            this.__explicitlySet__.add("actionsList");
            return this;
        }

        public Builder timeOfAction(Date timeOfAction) {
            this.timeOfAction = timeOfAction;
            this.__explicitlySet__.add("timeOfAction");
            return this;
        }

        public AccessRequestHistorySummary build() {
            AccessRequestHistorySummary model = new AccessRequestHistorySummary(this.lifecycleState, this.userId, this.description, this.duration, this.isAutoApproved, this.actionsList, this.timeOfAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AccessRequestHistorySummary model) {
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("isAutoApproved")) {
                this.isAutoApproved(model.getIsAutoApproved());
            }
            if (model.wasPropertyExplicitlySet("actionsList")) {
                this.actionsList(model.getActionsList());
            }
            if (model.wasPropertyExplicitlySet("timeOfAction")) {
                this.timeOfAction(model.getTimeOfAction());
            }
            return this;
        }
    }
}

