/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.OperatorControl;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlLifecycleStates;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorControlRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorControlResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OperatorControlWaiters {
    private final ExecutorService executorService;
    private final OperatorControl client;

    public OperatorControlWaiters(ExecutorService executorService, OperatorControl client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOperatorControlRequest, GetOperatorControlResponse> forOperatorControl(GetOperatorControlRequest request, OperatorControlLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperatorControl(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOperatorControlRequest, GetOperatorControlResponse> forOperatorControl(GetOperatorControlRequest request, OperatorControlLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOperatorControl(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOperatorControlRequest, GetOperatorControlResponse> forOperatorControl(GetOperatorControlRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OperatorControlLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperatorControl(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOperatorControlRequest, GetOperatorControlResponse> forOperatorControl(BmcGenericWaiter waiter, GetOperatorControlRequest request, OperatorControlLifecycleStates ... targetStates) {
        final HashSet<OperatorControlLifecycleStates> targetStatesSet = new HashSet<OperatorControlLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOperatorControlRequest, GetOperatorControlResponse>(){

            @Override
            public GetOperatorControlResponse apply(GetOperatorControlRequest request) {
                return OperatorControlWaiters.this.client.getOperatorControl(request);
            }
        }, (Predicate)new Predicate<GetOperatorControlResponse>(){

            @Override
            public boolean test(GetOperatorControlResponse response) {
                return targetStatesSet.contains((Object)response.getOperatorControl().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OperatorControlLifecycleStates.Deleted)), (Object)request);
    }
}

