/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.OperatorControl;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlSummary;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorControlsRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorControlsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OperatorControlPaginators {
    private final OperatorControl client;

    public OperatorControlPaginators(OperatorControl client) {
        this.client = client;
    }

    public Iterable<ListOperatorControlsResponse> listOperatorControlsResponseIterator(final ListOperatorControlsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOperatorControlsRequest.Builder>(){

            @Override
            public ListOperatorControlsRequest.Builder get() {
                return ListOperatorControlsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperatorControlsResponse, String>(){

            @Override
            public String apply(ListOperatorControlsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperatorControlsRequest.Builder>, ListOperatorControlsRequest>(){

            @Override
            public ListOperatorControlsRequest apply(RequestBuilderAndToken<ListOperatorControlsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperatorControlsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperatorControlsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperatorControlsRequest, ListOperatorControlsResponse>(){

            @Override
            public ListOperatorControlsResponse apply(ListOperatorControlsRequest request) {
                return OperatorControlPaginators.this.client.listOperatorControls(request);
            }
        });
    }

    public Iterable<OperatorControlSummary> listOperatorControlsRecordIterator(final ListOperatorControlsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOperatorControlsRequest.Builder>(){

            @Override
            public ListOperatorControlsRequest.Builder get() {
                return ListOperatorControlsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperatorControlsResponse, String>(){

            @Override
            public String apply(ListOperatorControlsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperatorControlsRequest.Builder>, ListOperatorControlsRequest>(){

            @Override
            public ListOperatorControlsRequest apply(RequestBuilderAndToken<ListOperatorControlsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperatorControlsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperatorControlsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperatorControlsRequest, ListOperatorControlsResponse>(){

            @Override
            public ListOperatorControlsResponse apply(ListOperatorControlsRequest request) {
                return OperatorControlPaginators.this.client.listOperatorControls(request);
            }
        }, (Function)new Function<ListOperatorControlsResponse, List<OperatorControlSummary>>(){

            @Override
            public List<OperatorControlSummary> apply(ListOperatorControlsResponse response) {
                return response.getOperatorControlCollection().getItems();
            }
        });
    }
}

