/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.operatoraccesscontrol.OperatorControlAsyncClient;
import com.oracle.bmc.operatoraccesscontrol.OperatorControlPaginators;
import com.oracle.bmc.operatoraccesscontrol.OperatorControlWaiters;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControl;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlCollection;
import com.oracle.bmc.operatoraccesscontrol.requests.ChangeOperatorControlCompartmentRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.CreateOperatorControlRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.DeleteOperatorControlRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorControlRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorControlsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.UpdateOperatorControlRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ChangeOperatorControlCompartmentResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.CreateOperatorControlResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.DeleteOperatorControlResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorControlResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorControlsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.UpdateOperatorControlResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorControlClient
extends BaseSyncClient
implements com.oracle.bmc.operatoraccesscontrol.OperatorControl {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPERATORCONTROL").serviceEndpointPrefix("").serviceEndpointTemplate("https://operator-access-control.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OperatorControlAsyncClient.class);
    private final OperatorControlWaiters waiters;
    private final OperatorControlPaginators paginators;

    private OperatorControlClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OperatorControl-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OperatorControlWaiters(executorService, this);
        this.paginators = new OperatorControlPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeOperatorControlCompartmentResponse changeOperatorControlCompartment(ChangeOperatorControlCompartmentRequest request) {
        Validate.notBlank((String)request.getOperatorControlId(), (String)"operatorControlId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOperatorControlCompartmentDetails(), "changeOperatorControlCompartmentDetails is required");
        return (ChangeOperatorControlCompartmentResponse)this.clientCall(request, ChangeOperatorControlCompartmentResponse::builder).logger(LOG, "changeOperatorControlCompartment").serviceDetails("OperatorControl", "ChangeOperatorControlCompartment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/ChangeOperatorControlCompartment").method(Method.POST).requestBuilder(ChangeOperatorControlCompartmentRequest::builder).basePath("/20200630").appendPathParam("operatorControls").appendPathParam(request.getOperatorControlId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeOperatorControlCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOperatorControlResponse createOperatorControl(CreateOperatorControlRequest request) {
        Objects.requireNonNull(request.getCreateOperatorControlDetails(), "createOperatorControlDetails is required");
        return (CreateOperatorControlResponse)this.clientCall(request, CreateOperatorControlResponse::builder).logger(LOG, "createOperatorControl").serviceDetails("OperatorControl", "CreateOperatorControl", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/CreateOperatorControl").method(Method.POST).requestBuilder(CreateOperatorControlRequest::builder).basePath("/20200630").appendPathParam("operatorControls").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OperatorControl.class, CreateOperatorControlResponse.Builder::operatorControl).handleResponseHeaderString("etag", CreateOperatorControlResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOperatorControlResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOperatorControlResponse deleteOperatorControl(DeleteOperatorControlRequest request) {
        Validate.notBlank((String)request.getOperatorControlId(), (String)"operatorControlId must not be blank", (Object[])new Object[0]);
        return (DeleteOperatorControlResponse)this.clientCall(request, DeleteOperatorControlResponse::builder).logger(LOG, "deleteOperatorControl").serviceDetails("OperatorControl", "DeleteOperatorControl", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/DeleteOperatorControl").method(Method.DELETE).requestBuilder(DeleteOperatorControlRequest::builder).basePath("/20200630").appendPathParam("operatorControls").appendPathParam(request.getOperatorControlId()).appendQueryParam("description", (Object)request.getDescription()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteOperatorControlResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOperatorControlResponse getOperatorControl(GetOperatorControlRequest request) {
        Validate.notBlank((String)request.getOperatorControlId(), (String)"operatorControlId must not be blank", (Object[])new Object[0]);
        return (GetOperatorControlResponse)this.clientCall(request, GetOperatorControlResponse::builder).logger(LOG, "getOperatorControl").serviceDetails("OperatorControl", "GetOperatorControl", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/GetOperatorControl").method(Method.GET).requestBuilder(GetOperatorControlRequest::builder).basePath("/20200630").appendPathParam("operatorControls").appendPathParam(request.getOperatorControlId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorControl.class, GetOperatorControlResponse.Builder::operatorControl).handleResponseHeaderString("etag", GetOperatorControlResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOperatorControlResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOperatorControlsResponse listOperatorControls(ListOperatorControlsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOperatorControlsResponse)this.clientCall(request, ListOperatorControlsResponse::builder).logger(LOG, "listOperatorControls").serviceDetails("OperatorControl", "ListOperatorControls", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/ListOperatorControls").method(Method.GET).requestBuilder(ListOperatorControlsRequest::builder).basePath("/20200630").appendPathParam("operatorControls").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorControlCollection.class, ListOperatorControlsResponse.Builder::operatorControlCollection).handleResponseHeaderString("opc-request-id", ListOperatorControlsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOperatorControlsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateOperatorControlResponse updateOperatorControl(UpdateOperatorControlRequest request) {
        Validate.notBlank((String)request.getOperatorControlId(), (String)"operatorControlId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOperatorControlDetails(), "updateOperatorControlDetails is required");
        return (UpdateOperatorControlResponse)this.clientCall(request, UpdateOperatorControlResponse::builder).logger(LOG, "updateOperatorControl").serviceDetails("OperatorControl", "UpdateOperatorControl", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControl/UpdateOperatorControl").method(Method.PUT).requestBuilder(UpdateOperatorControlRequest::builder).basePath("/20200630").appendPathParam("operatorControls").appendPathParam(request.getOperatorControlId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OperatorControl.class, UpdateOperatorControlResponse.Builder::operatorControl).handleResponseHeaderString("etag", UpdateOperatorControlResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOperatorControlResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OperatorControlWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OperatorControlPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OperatorControlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OperatorControlClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OperatorControlClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OperatorControlClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OperatorControlClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OperatorControlClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OperatorControlClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OperatorControlClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

