/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.OperatorControlAssignment;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlAssignmentLifecycleStates;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorControlAssignmentRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorControlAssignmentResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OperatorControlAssignmentWaiters {
    private final ExecutorService executorService;
    private final OperatorControlAssignment client;

    public OperatorControlAssignmentWaiters(ExecutorService executorService, OperatorControlAssignment client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse> forOperatorControlAssignment(GetOperatorControlAssignmentRequest request, OperatorControlAssignmentLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperatorControlAssignment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse> forOperatorControlAssignment(GetOperatorControlAssignmentRequest request, OperatorControlAssignmentLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOperatorControlAssignment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse> forOperatorControlAssignment(GetOperatorControlAssignmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OperatorControlAssignmentLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperatorControlAssignment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse> forOperatorControlAssignment(BmcGenericWaiter waiter, GetOperatorControlAssignmentRequest request, OperatorControlAssignmentLifecycleStates ... targetStates) {
        final HashSet<OperatorControlAssignmentLifecycleStates> targetStatesSet = new HashSet<OperatorControlAssignmentLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse>(){

            @Override
            public GetOperatorControlAssignmentResponse apply(GetOperatorControlAssignmentRequest request) {
                return OperatorControlAssignmentWaiters.this.client.getOperatorControlAssignment(request);
            }
        }, (Predicate)new Predicate<GetOperatorControlAssignmentResponse>(){

            @Override
            public boolean test(GetOperatorControlAssignmentResponse response) {
                return targetStatesSet.contains((Object)response.getOperatorControlAssignment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OperatorControlAssignmentLifecycleStates.Deleted)), (Object)request);
    }
}

