/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.operatoraccesscontrol.OperatorControlAssignmentAsync;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlAssignment;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorControlAssignmentCollection;
import com.oracle.bmc.operatoraccesscontrol.requests.ChangeOperatorControlAssignmentCompartmentRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.CreateOperatorControlAssignmentRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.DeleteOperatorControlAssignmentRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorControlAssignmentRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorControlAssignmentsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.UpdateOperatorControlAssignmentRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ChangeOperatorControlAssignmentCompartmentResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.CreateOperatorControlAssignmentResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.DeleteOperatorControlAssignmentResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorControlAssignmentResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorControlAssignmentsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.UpdateOperatorControlAssignmentResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorControlAssignmentAsyncClient
extends BaseAsyncClient
implements OperatorControlAssignmentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPERATORCONTROLASSIGNMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://operator-access-control.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OperatorControlAssignmentAsyncClient.class);

    private OperatorControlAssignmentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeOperatorControlAssignmentCompartmentResponse> changeOperatorControlAssignmentCompartment(ChangeOperatorControlAssignmentCompartmentRequest request, AsyncHandler<ChangeOperatorControlAssignmentCompartmentRequest, ChangeOperatorControlAssignmentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getOperatorControlAssignmentId(), (String)"operatorControlAssignmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOperatorControlAssignmentCompartmentDetails(), "changeOperatorControlAssignmentCompartmentDetails is required");
        return this.clientCall(request, ChangeOperatorControlAssignmentCompartmentResponse::builder).logger(LOG, "changeOperatorControlAssignmentCompartment").serviceDetails("OperatorControlAssignment", "ChangeOperatorControlAssignmentCompartment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/ChangeOperatorControlAssignmentCompartment").method(Method.POST).requestBuilder(ChangeOperatorControlAssignmentCompartmentRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").appendPathParam(request.getOperatorControlAssignmentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeOperatorControlAssignmentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOperatorControlAssignmentResponse> createOperatorControlAssignment(CreateOperatorControlAssignmentRequest request, AsyncHandler<CreateOperatorControlAssignmentRequest, CreateOperatorControlAssignmentResponse> handler) {
        Objects.requireNonNull(request.getCreateOperatorControlAssignmentDetails(), "createOperatorControlAssignmentDetails is required");
        return this.clientCall(request, CreateOperatorControlAssignmentResponse::builder).logger(LOG, "createOperatorControlAssignment").serviceDetails("OperatorControlAssignment", "CreateOperatorControlAssignment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/CreateOperatorControlAssignment").method(Method.POST).requestBuilder(CreateOperatorControlAssignmentRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OperatorControlAssignment.class, CreateOperatorControlAssignmentResponse.Builder::operatorControlAssignment).handleResponseHeaderString("etag", CreateOperatorControlAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateOperatorControlAssignmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOperatorControlAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOperatorControlAssignmentResponse> deleteOperatorControlAssignment(DeleteOperatorControlAssignmentRequest request, AsyncHandler<DeleteOperatorControlAssignmentRequest, DeleteOperatorControlAssignmentResponse> handler) {
        Validate.notBlank((String)request.getOperatorControlAssignmentId(), (String)"operatorControlAssignmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOperatorControlAssignmentResponse::builder).logger(LOG, "deleteOperatorControlAssignment").serviceDetails("OperatorControlAssignment", "DeleteOperatorControlAssignment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/DeleteOperatorControlAssignment").method(Method.DELETE).requestBuilder(DeleteOperatorControlAssignmentRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").appendPathParam(request.getOperatorControlAssignmentId()).appendQueryParam("description", (Object)request.getDescription()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteOperatorControlAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOperatorControlAssignmentResponse> getOperatorControlAssignment(GetOperatorControlAssignmentRequest request, AsyncHandler<GetOperatorControlAssignmentRequest, GetOperatorControlAssignmentResponse> handler) {
        Validate.notBlank((String)request.getOperatorControlAssignmentId(), (String)"operatorControlAssignmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOperatorControlAssignmentResponse::builder).logger(LOG, "getOperatorControlAssignment").serviceDetails("OperatorControlAssignment", "GetOperatorControlAssignment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/GetOperatorControlAssignment").method(Method.GET).requestBuilder(GetOperatorControlAssignmentRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").appendPathParam(request.getOperatorControlAssignmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorControlAssignment.class, GetOperatorControlAssignmentResponse.Builder::operatorControlAssignment).handleResponseHeaderString("etag", GetOperatorControlAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOperatorControlAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOperatorControlAssignmentsResponse> listOperatorControlAssignments(ListOperatorControlAssignmentsRequest request, AsyncHandler<ListOperatorControlAssignmentsRequest, ListOperatorControlAssignmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOperatorControlAssignmentsResponse::builder).logger(LOG, "listOperatorControlAssignments").serviceDetails("OperatorControlAssignment", "ListOperatorControlAssignments", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/ListOperatorControlAssignments").method(Method.GET).requestBuilder(ListOperatorControlAssignmentsRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").appendQueryParam("operatorControlName", (Object)request.getOperatorControlName()).appendQueryParam("resourceName", (Object)request.getResourceName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorControlAssignmentCollection.class, ListOperatorControlAssignmentsResponse.Builder::operatorControlAssignmentCollection).handleResponseHeaderString("opc-request-id", ListOperatorControlAssignmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOperatorControlAssignmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateOperatorControlAssignmentResponse> updateOperatorControlAssignment(UpdateOperatorControlAssignmentRequest request, AsyncHandler<UpdateOperatorControlAssignmentRequest, UpdateOperatorControlAssignmentResponse> handler) {
        Validate.notBlank((String)request.getOperatorControlAssignmentId(), (String)"operatorControlAssignmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOperatorControlAssignmentDetails(), "updateOperatorControlAssignmentDetails is required");
        return this.clientCall(request, UpdateOperatorControlAssignmentResponse::builder).logger(LOG, "updateOperatorControlAssignment").serviceDetails("OperatorControlAssignment", "UpdateOperatorControlAssignment", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorControlAssignment/UpdateOperatorControlAssignment").method(Method.PUT).requestBuilder(UpdateOperatorControlAssignmentRequest::builder).basePath("/20200630").appendPathParam("operatorControlAssignments").appendPathParam(request.getOperatorControlAssignmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OperatorControlAssignment.class, UpdateOperatorControlAssignmentResponse.Builder::operatorControlAssignment).handleResponseHeaderString("etag", UpdateOperatorControlAssignmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOperatorControlAssignmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OperatorControlAssignmentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OperatorControlAssignmentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OperatorControlAssignmentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OperatorControlAssignmentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OperatorControlAssignmentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OperatorControlAssignmentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorControlAssignmentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OperatorControlAssignmentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OperatorControlAssignmentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OperatorControlAssignmentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OperatorControlAssignmentAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

