/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.OperatorActions;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorActionSummary;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorActionsRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorActionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OperatorActionsPaginators {
    private final OperatorActions client;

    public OperatorActionsPaginators(OperatorActions client) {
        this.client = client;
    }

    public Iterable<ListOperatorActionsResponse> listOperatorActionsResponseIterator(final ListOperatorActionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOperatorActionsRequest.Builder>(){

            @Override
            public ListOperatorActionsRequest.Builder get() {
                return ListOperatorActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperatorActionsResponse, String>(){

            @Override
            public String apply(ListOperatorActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperatorActionsRequest.Builder>, ListOperatorActionsRequest>(){

            @Override
            public ListOperatorActionsRequest apply(RequestBuilderAndToken<ListOperatorActionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperatorActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperatorActionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperatorActionsRequest, ListOperatorActionsResponse>(){

            @Override
            public ListOperatorActionsResponse apply(ListOperatorActionsRequest request) {
                return OperatorActionsPaginators.this.client.listOperatorActions(request);
            }
        });
    }

    public Iterable<OperatorActionSummary> listOperatorActionsRecordIterator(final ListOperatorActionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOperatorActionsRequest.Builder>(){

            @Override
            public ListOperatorActionsRequest.Builder get() {
                return ListOperatorActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOperatorActionsResponse, String>(){

            @Override
            public String apply(ListOperatorActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOperatorActionsRequest.Builder>, ListOperatorActionsRequest>(){

            @Override
            public ListOperatorActionsRequest apply(RequestBuilderAndToken<ListOperatorActionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOperatorActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOperatorActionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOperatorActionsRequest, ListOperatorActionsResponse>(){

            @Override
            public ListOperatorActionsResponse apply(ListOperatorActionsRequest request) {
                return OperatorActionsPaginators.this.client.listOperatorActions(request);
            }
        }, (Function)new Function<ListOperatorActionsResponse, List<OperatorActionSummary>>(){

            @Override
            public List<OperatorActionSummary> apply(ListOperatorActionsResponse response) {
                return response.getOperatorActionCollection().getItems();
            }
        });
    }
}

