/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.operatoraccesscontrol.OperatorActions;
import com.oracle.bmc.operatoraccesscontrol.OperatorActionsAsyncClient;
import com.oracle.bmc.operatoraccesscontrol.OperatorActionsPaginators;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorAction;
import com.oracle.bmc.operatoraccesscontrol.model.OperatorActionCollection;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorActionRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorActionsRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorActionResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorActionsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorActionsClient
extends BaseSyncClient
implements OperatorActions {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPERATORACTIONS").serviceEndpointPrefix("").serviceEndpointTemplate("https://operator-access-control.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OperatorActionsAsyncClient.class);
    private final OperatorActionsPaginators paginators = new OperatorActionsPaginators(this);

    private OperatorActionsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetOperatorActionResponse getOperatorAction(GetOperatorActionRequest request) {
        Validate.notBlank((String)request.getOperatorActionId(), (String)"operatorActionId must not be blank", (Object[])new Object[0]);
        return (GetOperatorActionResponse)this.clientCall(request, GetOperatorActionResponse::builder).logger(LOG, "getOperatorAction").serviceDetails("OperatorActions", "GetOperatorAction", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorAction/GetOperatorAction").method(Method.GET).requestBuilder(GetOperatorActionRequest::builder).basePath("/20200630").appendPathParam("operatorActions").appendPathParam(request.getOperatorActionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorAction.class, GetOperatorActionResponse.Builder::operatorAction).handleResponseHeaderString("opc-request-id", GetOperatorActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOperatorActionsResponse listOperatorActions(ListOperatorActionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOperatorActionsResponse)this.clientCall(request, ListOperatorActionsResponse::builder).logger(LOG, "listOperatorActions").serviceDetails("OperatorActions", "ListOperatorActions", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/OperatorAction/ListOperatorActions").method(Method.GET).requestBuilder(ListOperatorActionsRequest::builder).basePath("/20200630").appendPathParam("operatorActions").appendQueryParam("name", (Object)request.getName()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperatorActionCollection.class, ListOperatorActionsResponse.Builder::operatorActionCollection).handleResponseHeaderString("opc-request-id", ListOperatorActionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOperatorActionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public OperatorActionsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OperatorActionsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OperatorActionsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OperatorActionsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OperatorActionsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OperatorActionsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OperatorActionsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OperatorActionsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OperatorActionsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OperatorActionsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OperatorActionsClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OperatorActionsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OperatorActionsClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

