/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.AccessRequests;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestLifecycleStates;
import com.oracle.bmc.operatoraccesscontrol.requests.GetAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.GetAccessRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AccessRequestsWaiters {
    private final ExecutorService executorService;
    private final AccessRequests client;

    public AccessRequestsWaiters(ExecutorService executorService, AccessRequests client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, AccessRequestLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, AccessRequestLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AccessRequestLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(BmcGenericWaiter waiter, GetAccessRequestRequest request, AccessRequestLifecycleStates ... targetStates) {
        final HashSet<AccessRequestLifecycleStates> targetStatesSet = new HashSet<AccessRequestLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAccessRequestRequest, GetAccessRequestResponse>(){

            @Override
            public GetAccessRequestResponse apply(GetAccessRequestRequest request) {
                return AccessRequestsWaiters.this.client.getAccessRequest(request);
            }
        }, (Predicate)new Predicate<GetAccessRequestResponse>(){

            @Override
            public boolean test(GetAccessRequestResponse response) {
                return targetStatesSet.contains((Object)response.getAccessRequest().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

