/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.operatoraccesscontrol.AccessRequests;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestHistorySummary;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestSummary;
import com.oracle.bmc.operatoraccesscontrol.model.InteractionSummary;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestHistoriesRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListInteractionsRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestHistoriesResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListInteractionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AccessRequestsPaginators {
    private final AccessRequests client;

    public AccessRequestsPaginators(AccessRequests client) {
        this.client = client;
    }

    public Iterable<ListAccessRequestHistoriesResponse> listAccessRequestHistoriesResponseIterator(final ListAccessRequestHistoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAccessRequestHistoriesRequest.Builder>(){

            @Override
            public ListAccessRequestHistoriesRequest.Builder get() {
                return ListAccessRequestHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestHistoriesResponse, String>(){

            @Override
            public String apply(ListAccessRequestHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestHistoriesRequest.Builder>, ListAccessRequestHistoriesRequest>(){

            @Override
            public ListAccessRequestHistoriesRequest apply(RequestBuilderAndToken<ListAccessRequestHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestHistoriesRequest, ListAccessRequestHistoriesResponse>(){

            @Override
            public ListAccessRequestHistoriesResponse apply(ListAccessRequestHistoriesRequest request) {
                return AccessRequestsPaginators.this.client.listAccessRequestHistories(request);
            }
        });
    }

    public Iterable<AccessRequestHistorySummary> listAccessRequestHistoriesRecordIterator(final ListAccessRequestHistoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAccessRequestHistoriesRequest.Builder>(){

            @Override
            public ListAccessRequestHistoriesRequest.Builder get() {
                return ListAccessRequestHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestHistoriesResponse, String>(){

            @Override
            public String apply(ListAccessRequestHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestHistoriesRequest.Builder>, ListAccessRequestHistoriesRequest>(){

            @Override
            public ListAccessRequestHistoriesRequest apply(RequestBuilderAndToken<ListAccessRequestHistoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestHistoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestHistoriesRequest, ListAccessRequestHistoriesResponse>(){

            @Override
            public ListAccessRequestHistoriesResponse apply(ListAccessRequestHistoriesRequest request) {
                return AccessRequestsPaginators.this.client.listAccessRequestHistories(request);
            }
        }, (Function)new Function<ListAccessRequestHistoriesResponse, List<AccessRequestHistorySummary>>(){

            @Override
            public List<AccessRequestHistorySummary> apply(ListAccessRequestHistoriesResponse response) {
                return response.getAccessRequestHistoryCollection().getItems();
            }
        });
    }

    public Iterable<ListAccessRequestsResponse> listAccessRequestsResponseIterator(final ListAccessRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAccessRequestsRequest.Builder>(){

            @Override
            public ListAccessRequestsRequest.Builder get() {
                return ListAccessRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, String>(){

            @Override
            public String apply(ListAccessRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestsRequest.Builder>, ListAccessRequestsRequest>(){

            @Override
            public ListAccessRequestsRequest apply(RequestBuilderAndToken<ListAccessRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestsRequest, ListAccessRequestsResponse>(){

            @Override
            public ListAccessRequestsResponse apply(ListAccessRequestsRequest request) {
                return AccessRequestsPaginators.this.client.listAccessRequests(request);
            }
        });
    }

    public Iterable<AccessRequestSummary> listAccessRequestsRecordIterator(final ListAccessRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAccessRequestsRequest.Builder>(){

            @Override
            public ListAccessRequestsRequest.Builder get() {
                return ListAccessRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, String>(){

            @Override
            public String apply(ListAccessRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestsRequest.Builder>, ListAccessRequestsRequest>(){

            @Override
            public ListAccessRequestsRequest apply(RequestBuilderAndToken<ListAccessRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestsRequest, ListAccessRequestsResponse>(){

            @Override
            public ListAccessRequestsResponse apply(ListAccessRequestsRequest request) {
                return AccessRequestsPaginators.this.client.listAccessRequests(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, List<AccessRequestSummary>>(){

            @Override
            public List<AccessRequestSummary> apply(ListAccessRequestsResponse response) {
                return response.getAccessRequestCollection().getItems();
            }
        });
    }

    public Iterable<ListInteractionsResponse> listInteractionsResponseIterator(final ListInteractionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInteractionsRequest.Builder>(){

            @Override
            public ListInteractionsRequest.Builder get() {
                return ListInteractionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInteractionsResponse, String>(){

            @Override
            public String apply(ListInteractionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInteractionsRequest.Builder>, ListInteractionsRequest>(){

            @Override
            public ListInteractionsRequest apply(RequestBuilderAndToken<ListInteractionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInteractionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInteractionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInteractionsRequest, ListInteractionsResponse>(){

            @Override
            public ListInteractionsResponse apply(ListInteractionsRequest request) {
                return AccessRequestsPaginators.this.client.listInteractions(request);
            }
        });
    }

    public Iterable<InteractionSummary> listInteractionsRecordIterator(final ListInteractionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInteractionsRequest.Builder>(){

            @Override
            public ListInteractionsRequest.Builder get() {
                return ListInteractionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInteractionsResponse, String>(){

            @Override
            public String apply(ListInteractionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInteractionsRequest.Builder>, ListInteractionsRequest>(){

            @Override
            public ListInteractionsRequest apply(RequestBuilderAndToken<ListInteractionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInteractionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInteractionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInteractionsRequest, ListInteractionsResponse>(){

            @Override
            public ListInteractionsResponse apply(ListInteractionsRequest request) {
                return AccessRequestsPaginators.this.client.listInteractions(request);
            }
        }, (Function)new Function<ListInteractionsResponse, List<InteractionSummary>>(){

            @Override
            public List<InteractionSummary> apply(ListInteractionsResponse response) {
                return response.getInteractionCollection().getItems();
            }
        });
    }
}

