/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.operatoraccesscontrol;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.operatoraccesscontrol.AccessRequestsAsync;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequest;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestCollection;
import com.oracle.bmc.operatoraccesscontrol.model.AccessRequestHistoryCollection;
import com.oracle.bmc.operatoraccesscontrol.model.InteractionCollection;
import com.oracle.bmc.operatoraccesscontrol.requests.ApproveAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.InteractionRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestHistoriesRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListInteractionsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RejectAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ReviewAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RevokeAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ApproveAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.InteractionRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestHistoriesResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListInteractionsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RejectAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ReviewAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RevokeAccessRequestResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessRequestsAsyncClient
extends BaseAsyncClient
implements AccessRequestsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ACCESSREQUESTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://operator-access-control.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AccessRequestsAsyncClient.class);

    private AccessRequestsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ApproveAccessRequestResponse> approveAccessRequest(ApproveAccessRequestRequest request, AsyncHandler<ApproveAccessRequestRequest, ApproveAccessRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getApproveAccessRequestDetails(), "approveAccessRequestDetails is required");
        return this.clientCall(request, ApproveAccessRequestResponse::builder).logger(LOG, "approveAccessRequest").serviceDetails("AccessRequests", "ApproveAccessRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/ApproveAccessRequest").method(Method.POST).requestBuilder(ApproveAccessRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("action").appendPathParam("approve").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ApproveAccessRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ApproveAccessRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAccessRequestResponse> getAccessRequest(GetAccessRequestRequest request, AsyncHandler<GetAccessRequestRequest, GetAccessRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAccessRequestResponse::builder).logger(LOG, "getAccessRequest").serviceDetails("AccessRequests", "GetAccessRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/GetAccessRequest").method(Method.GET).requestBuilder(GetAccessRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AccessRequest.class, GetAccessRequestResponse.Builder::accessRequest).handleResponseHeaderString("opc-request-id", GetAccessRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InteractionRequestResponse> interactionRequest(InteractionRequestRequest request, AsyncHandler<InteractionRequestRequest, InteractionRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInteractionRequestDetails(), "interactionRequestDetails is required");
        return this.clientCall(request, InteractionRequestResponse::builder).logger(LOG, "interactionRequest").serviceDetails("AccessRequests", "InteractionRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/InteractionRequest").method(Method.POST).requestBuilder(InteractionRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("action").appendPathParam("interactionRequest").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AccessRequest.class, InteractionRequestResponse.Builder::accessRequest).handleResponseHeaderString("etag", InteractionRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", InteractionRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAccessRequestHistoriesResponse> listAccessRequestHistories(ListAccessRequestHistoriesRequest request, AsyncHandler<ListAccessRequestHistoriesRequest, ListAccessRequestHistoriesResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAccessRequestHistoriesResponse::builder).logger(LOG, "listAccessRequestHistories").serviceDetails("AccessRequests", "ListAccessRequestHistories", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/ListAccessRequestHistories").method(Method.GET).requestBuilder(ListAccessRequestHistoriesRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("history").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AccessRequestHistoryCollection.class, ListAccessRequestHistoriesResponse.Builder::accessRequestHistoryCollection).handleResponseHeaderString("opc-request-id", ListAccessRequestHistoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAccessRequestHistoriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAccessRequestsResponse> listAccessRequests(ListAccessRequestsRequest request, AsyncHandler<ListAccessRequestsRequest, ListAccessRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAccessRequestsResponse::builder).logger(LOG, "listAccessRequests").serviceDetails("AccessRequests", "ListAccessRequests", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/ListAccessRequests").method(Method.GET).requestBuilder(ListAccessRequestsRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceName", (Object)request.getResourceName()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AccessRequestCollection.class, ListAccessRequestsResponse.Builder::accessRequestCollection).handleResponseHeaderString("opc-request-id", ListAccessRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAccessRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListInteractionsResponse> listInteractions(ListInteractionsRequest request, AsyncHandler<ListInteractionsRequest, ListInteractionsResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListInteractionsResponse::builder).logger(LOG, "listInteractions").serviceDetails("AccessRequests", "ListInteractions", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/ListInteractions").method(Method.GET).requestBuilder(ListInteractionsRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("interactions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InteractionCollection.class, ListInteractionsResponse.Builder::interactionCollection).handleResponseHeaderString("opc-request-id", ListInteractionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInteractionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RejectAccessRequestResponse> rejectAccessRequest(RejectAccessRequestRequest request, AsyncHandler<RejectAccessRequestRequest, RejectAccessRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRejectAccessRequestDetails(), "rejectAccessRequestDetails is required");
        return this.clientCall(request, RejectAccessRequestResponse::builder).logger(LOG, "rejectAccessRequest").serviceDetails("AccessRequests", "RejectAccessRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/RejectAccessRequest").method(Method.POST).requestBuilder(RejectAccessRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("action").appendPathParam("reject").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RejectAccessRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RejectAccessRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ReviewAccessRequestResponse> reviewAccessRequest(ReviewAccessRequestRequest request, AsyncHandler<ReviewAccessRequestRequest, ReviewAccessRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getReviewAccessRequestDetails(), "reviewAccessRequestDetails is required");
        return this.clientCall(request, ReviewAccessRequestResponse::builder).logger(LOG, "reviewAccessRequest").serviceDetails("AccessRequests", "ReviewAccessRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/ReviewAccessRequest").method(Method.POST).requestBuilder(ReviewAccessRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("action").appendPathParam("review").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AccessRequest.class, ReviewAccessRequestResponse.Builder::accessRequest).handleResponseHeaderString("etag", ReviewAccessRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ReviewAccessRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RevokeAccessRequestResponse> revokeAccessRequest(RevokeAccessRequestRequest request, AsyncHandler<RevokeAccessRequestRequest, RevokeAccessRequestResponse> handler) {
        Validate.notBlank((String)request.getAccessRequestId(), (String)"accessRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevokeAccessRequestDetails(), "revokeAccessRequestDetails is required");
        return this.clientCall(request, RevokeAccessRequestResponse::builder).logger(LOG, "revokeAccessRequest").serviceDetails("AccessRequests", "RevokeAccessRequest", "https://docs.oracle.com/iaas/api/#/en/operatoraccesscontrol/20200630/AccessRequest/RevokeAccessRequest").method(Method.POST).requestBuilder(RevokeAccessRequestRequest::builder).basePath("/20200630").appendPathParam("accessRequests").appendPathParam(request.getAccessRequestId()).appendPathParam("action").appendPathParam("revoke").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RevokeAccessRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RevokeAccessRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AccessRequestsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AccessRequestsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AccessRequestsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AccessRequestsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AccessRequestsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AccessRequestsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AccessRequestsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessRequestsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AccessRequestsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AccessRequestsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AccessRequestsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AccessRequestsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

