/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opa;

import com.oracle.bmc.opa.OpaInstance;
import com.oracle.bmc.opa.model.OpaInstance;
import com.oracle.bmc.opa.requests.GetOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetWorkRequestRequest;
import com.oracle.bmc.opa.responses.GetOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OpaInstanceWaiters {
    private final ExecutorService executorService;
    private final OpaInstance client;

    public OpaInstanceWaiters(ExecutorService executorService, OpaInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOpaInstanceRequest, GetOpaInstanceResponse> forOpaInstance(GetOpaInstanceRequest request, OpaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOpaInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOpaInstanceRequest, GetOpaInstanceResponse> forOpaInstance(GetOpaInstanceRequest request, OpaInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOpaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOpaInstanceRequest, GetOpaInstanceResponse> forOpaInstance(GetOpaInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OpaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOpaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOpaInstanceRequest, GetOpaInstanceResponse> forOpaInstance(BmcGenericWaiter waiter, GetOpaInstanceRequest request, OpaInstance.LifecycleState ... targetStates) {
        final HashSet<OpaInstance.LifecycleState> targetStatesSet = new HashSet<OpaInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOpaInstanceRequest, GetOpaInstanceResponse>(){

            @Override
            public GetOpaInstanceResponse apply(GetOpaInstanceRequest request) {
                return OpaInstanceWaiters.this.client.getOpaInstance(request);
            }
        }, (Predicate)new Predicate<GetOpaInstanceResponse>(){

            @Override
            public boolean test(GetOpaInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getOpaInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OpaInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OpaInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

