/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opa;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.opa.OpaInstanceAsync;
import com.oracle.bmc.opa.model.OpaInstance;
import com.oracle.bmc.opa.model.OpaInstanceCollection;
import com.oracle.bmc.opa.model.WorkRequest;
import com.oracle.bmc.opa.model.WorkRequestErrorCollection;
import com.oracle.bmc.opa.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.opa.model.WorkRequestSummaryCollection;
import com.oracle.bmc.opa.requests.CancelWorkRequestRequest;
import com.oracle.bmc.opa.requests.ChangeOpaInstanceCompartmentRequest;
import com.oracle.bmc.opa.requests.CreateOpaInstanceRequest;
import com.oracle.bmc.opa.requests.DeleteOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetWorkRequestRequest;
import com.oracle.bmc.opa.requests.ListOpaInstancesRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opa.requests.UpdateOpaInstanceRequest;
import com.oracle.bmc.opa.responses.CancelWorkRequestResponse;
import com.oracle.bmc.opa.responses.ChangeOpaInstanceCompartmentResponse;
import com.oracle.bmc.opa.responses.CreateOpaInstanceResponse;
import com.oracle.bmc.opa.responses.DeleteOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetWorkRequestResponse;
import com.oracle.bmc.opa.responses.ListOpaInstancesResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opa.responses.UpdateOpaInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaInstanceAsyncClient
extends BaseAsyncClient
implements OpaInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPAINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://process-automation.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OpaInstanceAsyncClient.class);

    private OpaInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("OpaInstance", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeOpaInstanceCompartmentResponse> changeOpaInstanceCompartment(ChangeOpaInstanceCompartmentRequest request, AsyncHandler<ChangeOpaInstanceCompartmentRequest, ChangeOpaInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOpaInstanceCompartmentDetails(), "changeOpaInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeOpaInstanceCompartmentResponse::builder).logger(LOG, "changeOpaInstanceCompartment").serviceDetails("OpaInstance", "ChangeOpaInstanceCompartment", "").method(Method.POST).requestBuilder(ChangeOpaInstanceCompartmentRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOpaInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOpaInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOpaInstanceResponse> createOpaInstance(CreateOpaInstanceRequest request, AsyncHandler<CreateOpaInstanceRequest, CreateOpaInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateOpaInstanceDetails(), "createOpaInstanceDetails is required");
        return this.clientCall(request, CreateOpaInstanceResponse::builder).logger(LOG, "createOpaInstance").serviceDetails("OpaInstance", "CreateOpaInstance", "").method(Method.POST).requestBuilder(CreateOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOpaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOpaInstanceResponse> deleteOpaInstance(DeleteOpaInstanceRequest request, AsyncHandler<DeleteOpaInstanceRequest, DeleteOpaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOpaInstanceResponse::builder).logger(LOG, "deleteOpaInstance").serviceDetails("OpaInstance", "DeleteOpaInstance", "").method(Method.DELETE).requestBuilder(DeleteOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOpaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOpaInstanceResponse> getOpaInstance(GetOpaInstanceRequest request, AsyncHandler<GetOpaInstanceRequest, GetOpaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOpaInstanceResponse::builder).logger(LOG, "getOpaInstance").serviceDetails("OpaInstance", "GetOpaInstance", "").method(Method.GET).requestBuilder(GetOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpaInstance.class, GetOpaInstanceResponse.Builder::opaInstance).handleResponseHeaderString("etag", GetOpaInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOpaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OpaInstance", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListOpaInstancesResponse> listOpaInstances(ListOpaInstancesRequest request, AsyncHandler<ListOpaInstancesRequest, ListOpaInstancesResponse> handler) {
        return this.clientCall(request, ListOpaInstancesResponse::builder).logger(LOG, "listOpaInstances").serviceDetails("OpaInstance", "ListOpaInstances", "").method(Method.GET).requestBuilder(ListOpaInstancesRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpaInstanceCollection.class, ListOpaInstancesResponse.Builder::opaInstanceCollection).handleResponseHeaderString("opc-request-id", ListOpaInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpaInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OpaInstance", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OpaInstance", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OpaInstance", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateOpaInstanceResponse> updateOpaInstance(UpdateOpaInstanceRequest request, AsyncHandler<UpdateOpaInstanceRequest, UpdateOpaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOpaInstanceDetails(), "updateOpaInstanceDetails is required");
        return this.clientCall(request, UpdateOpaInstanceResponse::builder).logger(LOG, "updateOpaInstance").serviceDetails("OpaInstance", "UpdateOpaInstance", "").method(Method.PUT).requestBuilder(UpdateOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOpaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OpaInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OpaInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OpaInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OpaInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OpaInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OpaInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OpaInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OpaInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpaInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OpaInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OpaInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OpaInstanceAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

