/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.oracle.bmc.ons.NotificationControlPlane;
import com.oracle.bmc.ons.model.NotificationTopicSummary;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class NotificationControlPlanePaginators {
    private final NotificationControlPlane client;

    public NotificationControlPlanePaginators(NotificationControlPlane client) {
        this.client = client;
    }

    public Iterable<ListTopicsResponse> listTopicsResponseIterator(final ListTopicsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTopicsRequest.Builder>(){

            @Override
            public ListTopicsRequest.Builder get() {
                return ListTopicsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopicsResponse, String>(){

            @Override
            public String apply(ListTopicsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopicsRequest.Builder>, ListTopicsRequest>(){

            @Override
            public ListTopicsRequest apply(RequestBuilderAndToken<ListTopicsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopicsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopicsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopicsRequest, ListTopicsResponse>(){

            @Override
            public ListTopicsResponse apply(ListTopicsRequest request) {
                return NotificationControlPlanePaginators.this.client.listTopics(request);
            }
        });
    }

    public Iterable<NotificationTopicSummary> listTopicsRecordIterator(final ListTopicsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTopicsRequest.Builder>(){

            @Override
            public ListTopicsRequest.Builder get() {
                return ListTopicsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTopicsResponse, String>(){

            @Override
            public String apply(ListTopicsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTopicsRequest.Builder>, ListTopicsRequest>(){

            @Override
            public ListTopicsRequest apply(RequestBuilderAndToken<ListTopicsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTopicsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTopicsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTopicsRequest, ListTopicsResponse>(){

            @Override
            public ListTopicsResponse apply(ListTopicsRequest request) {
                return NotificationControlPlanePaginators.this.client.listTopics(request);
            }
        }, (Function)new Function<ListTopicsResponse, List<NotificationTopicSummary>>(){

            @Override
            public List<NotificationTopicSummary> apply(ListTopicsResponse response) {
                return response.getItems();
            }
        });
    }
}

