/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSubscribedServicesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String subscriptionId;
    private Long orderLineId;
    private String status;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Long getOrderLineId() {
        return this.orderLineId;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).subscriptionId(this.subscriptionId).orderLineId(this.orderLineId).status(this.status).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",orderLineId=").append(String.valueOf(this.orderLineId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSubscribedServicesRequest)) {
            return false;
        }
        ListSubscribedServicesRequest other = (ListSubscribedServicesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.orderLineId, other.orderLineId) && Objects.equals(this.status, other.status) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.orderLineId == null ? 43 : this.orderLineId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSubscribedServicesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String subscriptionId = null;
        private Long orderLineId = null;
        private String status = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder orderLineId(Long orderLineId) {
            this.orderLineId = orderLineId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSubscribedServicesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.subscriptionId(o.getSubscriptionId());
            this.orderLineId(o.getOrderLineId());
            this.status(o.getStatus());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSubscribedServicesRequest build() {
            ListSubscribedServicesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSubscribedServicesRequest buildWithoutInvocationCallback() {
            ListSubscribedServicesRequest request = new ListSubscribedServicesRequest();
            request.compartmentId = this.compartmentId;
            request.subscriptionId = this.subscriptionId;
            request.orderLineId = this.orderLineId;
            request.status = this.status;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Ordernumber("ORDERNUMBER"),
        Timeinvoicing("TIMEINVOICING");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

