/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOdaInstanceAttachmentRequest
extends BmcRequest<Void> {
    private String odaInstanceId;
    private String attachmentId;
    private Boolean includeOwnerMetadata;
    private String opcRequestId;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public Boolean getIncludeOwnerMetadata() {
        return this.includeOwnerMetadata;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).attachmentId(this.attachmentId).includeOwnerMetadata(this.includeOwnerMetadata).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",attachmentId=").append(String.valueOf(this.attachmentId));
        sb.append(",includeOwnerMetadata=").append(String.valueOf(this.includeOwnerMetadata));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOdaInstanceAttachmentRequest)) {
            return false;
        }
        GetOdaInstanceAttachmentRequest other = (GetOdaInstanceAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.attachmentId, other.attachmentId) && Objects.equals(this.includeOwnerMetadata, other.includeOwnerMetadata) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.attachmentId == null ? 43 : this.attachmentId.hashCode());
        result = result * 59 + (this.includeOwnerMetadata == null ? 43 : this.includeOwnerMetadata.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOdaInstanceAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String attachmentId = null;
        private Boolean includeOwnerMetadata = null;
        private String opcRequestId = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder includeOwnerMetadata(Boolean includeOwnerMetadata) {
            this.includeOwnerMetadata = includeOwnerMetadata;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOdaInstanceAttachmentRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.attachmentId(o.getAttachmentId());
            this.includeOwnerMetadata(o.getIncludeOwnerMetadata());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOdaInstanceAttachmentRequest build() {
            GetOdaInstanceAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOdaInstanceAttachmentRequest buildWithoutInvocationCallback() {
            GetOdaInstanceAttachmentRequest request = new GetOdaInstanceAttachmentRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.attachmentId = this.attachmentId;
            request.includeOwnerMetadata = this.includeOwnerMetadata;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

