/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAuthenticationProviderRequest
extends BmcRequest<Void> {
    private String odaInstanceId;
    private String authenticationProviderId;
    private String opcRequestId;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getAuthenticationProviderId() {
        return this.authenticationProviderId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).authenticationProviderId(this.authenticationProviderId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",authenticationProviderId=").append(String.valueOf(this.authenticationProviderId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAuthenticationProviderRequest)) {
            return false;
        }
        GetAuthenticationProviderRequest other = (GetAuthenticationProviderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.authenticationProviderId, other.authenticationProviderId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.authenticationProviderId == null ? 43 : this.authenticationProviderId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAuthenticationProviderRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String authenticationProviderId = null;
        private String opcRequestId = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder authenticationProviderId(String authenticationProviderId) {
            this.authenticationProviderId = authenticationProviderId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAuthenticationProviderRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.authenticationProviderId(o.getAuthenticationProviderId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAuthenticationProviderRequest build() {
            GetAuthenticationProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAuthenticationProviderRequest buildWithoutInvocationCallback() {
            GetAuthenticationProviderRequest request = new GetAuthenticationProviderRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.authenticationProviderId = this.authenticationProviderId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

