/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.ServiceCloudClientType;
import com.oracle.bmc.oda.model.UpdateChannelDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateServiceCloudChannelDetails
extends UpdateChannelDetails {
    @JsonProperty(value="domainName")
    private final String domainName;
    @JsonProperty(value="hostNamePrefix")
    private final String hostNamePrefix;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="clientType")
    private final ServiceCloudClientType clientType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateServiceCloudChannelDetails(String description, Long sessionExpiryDurationInMilliseconds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String domainName, String hostNamePrefix, String userName, String password, ServiceCloudClientType clientType) {
        super(description, sessionExpiryDurationInMilliseconds, freeformTags, definedTags);
        this.domainName = domainName;
        this.hostNamePrefix = hostNamePrefix;
        this.userName = userName;
        this.password = password;
        this.clientType = clientType;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getHostNamePrefix() {
        return this.hostNamePrefix;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public ServiceCloudClientType getClientType() {
        return this.clientType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateServiceCloudChannelDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", domainName=").append(String.valueOf(this.domainName));
        sb.append(", hostNamePrefix=").append(String.valueOf(this.hostNamePrefix));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", password=").append("<redacted>");
        sb.append(", clientType=").append(String.valueOf((Object)this.clientType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateServiceCloudChannelDetails)) {
            return false;
        }
        UpdateServiceCloudChannelDetails other = (UpdateServiceCloudChannelDetails)((Object)o);
        return Objects.equals(this.domainName, other.domainName) && Objects.equals(this.hostNamePrefix, other.hostNamePrefix) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password) && Objects.equals((Object)this.clientType, (Object)other.clientType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.domainName == null ? 43 : this.domainName.hashCode());
        result = result * 59 + (this.hostNamePrefix == null ? 43 : this.hostNamePrefix.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.clientType == null ? 43 : this.clientType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sessionExpiryDurationInMilliseconds")
        private Long sessionExpiryDurationInMilliseconds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="domainName")
        private String domainName;
        @JsonProperty(value="hostNamePrefix")
        private String hostNamePrefix;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="clientType")
        private ServiceCloudClientType clientType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder sessionExpiryDurationInMilliseconds(Long sessionExpiryDurationInMilliseconds) {
            this.sessionExpiryDurationInMilliseconds = sessionExpiryDurationInMilliseconds;
            this.__explicitlySet__.add("sessionExpiryDurationInMilliseconds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.__explicitlySet__.add("domainName");
            return this;
        }

        public Builder hostNamePrefix(String hostNamePrefix) {
            this.hostNamePrefix = hostNamePrefix;
            this.__explicitlySet__.add("hostNamePrefix");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder clientType(ServiceCloudClientType clientType) {
            this.clientType = clientType;
            this.__explicitlySet__.add("clientType");
            return this;
        }

        public UpdateServiceCloudChannelDetails build() {
            UpdateServiceCloudChannelDetails model = new UpdateServiceCloudChannelDetails(this.description, this.sessionExpiryDurationInMilliseconds, this.freeformTags, this.definedTags, this.domainName, this.hostNamePrefix, this.userName, this.password, this.clientType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateServiceCloudChannelDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("sessionExpiryDurationInMilliseconds")) {
                this.sessionExpiryDurationInMilliseconds(model.getSessionExpiryDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("domainName")) {
                this.domainName(model.getDomainName());
            }
            if (model.wasPropertyExplicitlySet("hostNamePrefix")) {
                this.hostNamePrefix(model.getHostNamePrefix());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("clientType")) {
                this.clientType(model.getClientType());
            }
            return this;
        }
    }
}

