/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ParameterDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;
    @JsonProperty(value="isSensitive")
    private final Boolean isSensitive;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="minLength")
    private final Integer minLength;
    @JsonProperty(value="maxLength")
    private final Integer maxLength;
    @JsonProperty(value="pattern")
    private final String pattern;
    @JsonProperty(value="direction")
    private final Direction direction;
    @JsonProperty(value="uiPlacementHint")
    private final String uiPlacementHint;
    @JsonProperty(value="resourceTypeMetadata")
    private final Object resourceTypeMetadata;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "description", "isRequired", "isSensitive", "defaultValue", "minLength", "maxLength", "pattern", "direction", "uiPlacementHint", "resourceTypeMetadata"})
    public ParameterDefinition(String name, Type type, String description, Boolean isRequired, Boolean isSensitive, String defaultValue, Integer minLength, Integer maxLength, String pattern, Direction direction, String uiPlacementHint, Object resourceTypeMetadata) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.isRequired = isRequired;
        this.isSensitive = isSensitive;
        this.defaultValue = defaultValue;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
        this.direction = direction;
        this.uiPlacementHint = uiPlacementHint;
        this.resourceTypeMetadata = resourceTypeMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public Boolean getIsSensitive() {
        return this.isSensitive;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getUiPlacementHint() {
        return this.uiPlacementHint;
    }

    public Object getResourceTypeMetadata() {
        return this.resourceTypeMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParameterDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(", isSensitive=").append(String.valueOf(this.isSensitive));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", minLength=").append(String.valueOf(this.minLength));
        sb.append(", maxLength=").append(String.valueOf(this.maxLength));
        sb.append(", pattern=").append(String.valueOf(this.pattern));
        sb.append(", direction=").append(String.valueOf((Object)this.direction));
        sb.append(", uiPlacementHint=").append(String.valueOf(this.uiPlacementHint));
        sb.append(", resourceTypeMetadata=").append(String.valueOf(this.resourceTypeMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.isRequired, other.isRequired) && Objects.equals(this.isSensitive, other.isSensitive) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.minLength, other.minLength) && Objects.equals(this.maxLength, other.maxLength) && Objects.equals(this.pattern, other.pattern) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.uiPlacementHint, other.uiPlacementHint) && Objects.equals(this.resourceTypeMetadata, other.resourceTypeMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + (this.isSensitive == null ? 43 : this.isSensitive.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.minLength == null ? 43 : this.minLength.hashCode());
        result = result * 59 + (this.maxLength == null ? 43 : this.maxLength.hashCode());
        result = result * 59 + (this.pattern == null ? 43 : this.pattern.hashCode());
        result = result * 59 + (this.direction == null ? 43 : this.direction.hashCode());
        result = result * 59 + (this.uiPlacementHint == null ? 43 : this.uiPlacementHint.hashCode());
        result = result * 59 + (this.resourceTypeMetadata == null ? 43 : this.resourceTypeMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Direction implements BmcEnum
    {
        Input("INPUT"),
        Output("OUTPUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Direction> map;

        private Direction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Direction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Direction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Direction.class);
            map = new HashMap<String, Direction>();
            for (Direction v : Direction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        String("STRING"),
        Uri("URI"),
        Url("URL"),
        Number("NUMBER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonProperty(value="isSensitive")
        private Boolean isSensitive;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="minLength")
        private Integer minLength;
        @JsonProperty(value="maxLength")
        private Integer maxLength;
        @JsonProperty(value="pattern")
        private String pattern;
        @JsonProperty(value="direction")
        private Direction direction;
        @JsonProperty(value="uiPlacementHint")
        private String uiPlacementHint;
        @JsonProperty(value="resourceTypeMetadata")
        private Object resourceTypeMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public Builder isSensitive(Boolean isSensitive) {
            this.isSensitive = isSensitive;
            this.__explicitlySet__.add("isSensitive");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder minLength(Integer minLength) {
            this.minLength = minLength;
            this.__explicitlySet__.add("minLength");
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            this.__explicitlySet__.add("maxLength");
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            this.__explicitlySet__.add("pattern");
            return this;
        }

        public Builder direction(Direction direction) {
            this.direction = direction;
            this.__explicitlySet__.add("direction");
            return this;
        }

        public Builder uiPlacementHint(String uiPlacementHint) {
            this.uiPlacementHint = uiPlacementHint;
            this.__explicitlySet__.add("uiPlacementHint");
            return this;
        }

        public Builder resourceTypeMetadata(Object resourceTypeMetadata) {
            this.resourceTypeMetadata = resourceTypeMetadata;
            this.__explicitlySet__.add("resourceTypeMetadata");
            return this;
        }

        public ParameterDefinition build() {
            ParameterDefinition model = new ParameterDefinition(this.name, this.type, this.description, this.isRequired, this.isSensitive, this.defaultValue, this.minLength, this.maxLength, this.pattern, this.direction, this.uiPlacementHint, this.resourceTypeMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ParameterDefinition model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            if (model.wasPropertyExplicitlySet("isSensitive")) {
                this.isSensitive(model.getIsSensitive());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("minLength")) {
                this.minLength(model.getMinLength());
            }
            if (model.wasPropertyExplicitlySet("maxLength")) {
                this.maxLength(model.getMaxLength());
            }
            if (model.wasPropertyExplicitlySet("pattern")) {
                this.pattern(model.getPattern());
            }
            if (model.wasPropertyExplicitlySet("direction")) {
                this.direction(model.getDirection());
            }
            if (model.wasPropertyExplicitlySet("uiPlacementHint")) {
                this.uiPlacementHint(model.getUiPlacementHint());
            }
            if (model.wasPropertyExplicitlySet("resourceTypeMetadata")) {
                this.resourceTypeMetadata(model.getResourceTypeMetadata());
            }
            return this;
        }
    }
}

