/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.oda.Management;
import com.oracle.bmc.oda.ManagementAsyncClient;
import com.oracle.bmc.oda.ManagementPaginators;
import com.oracle.bmc.oda.ManagementWaiters;
import com.oracle.bmc.oda.model.AuthenticationProvider;
import com.oracle.bmc.oda.model.AuthenticationProviderCollection;
import com.oracle.bmc.oda.model.Channel;
import com.oracle.bmc.oda.model.ChannelCollection;
import com.oracle.bmc.oda.model.CreateChannelResult;
import com.oracle.bmc.oda.model.DigitalAssistant;
import com.oracle.bmc.oda.model.DigitalAssistantCollection;
import com.oracle.bmc.oda.model.DigitalAssistantParameter;
import com.oracle.bmc.oda.model.DigitalAssistantParameterCollection;
import com.oracle.bmc.oda.model.Skill;
import com.oracle.bmc.oda.model.SkillCollection;
import com.oracle.bmc.oda.model.SkillParameter;
import com.oracle.bmc.oda.model.SkillParameterCollection;
import com.oracle.bmc.oda.model.Translator;
import com.oracle.bmc.oda.model.TranslatorCollection;
import com.oracle.bmc.oda.requests.ConfigureDigitalAssistantParametersRequest;
import com.oracle.bmc.oda.requests.CreateAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.CreateChannelRequest;
import com.oracle.bmc.oda.requests.CreateDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.CreateSkillParameterRequest;
import com.oracle.bmc.oda.requests.CreateSkillRequest;
import com.oracle.bmc.oda.requests.CreateTranslatorRequest;
import com.oracle.bmc.oda.requests.DeleteAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.DeleteChannelRequest;
import com.oracle.bmc.oda.requests.DeleteDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.DeleteSkillParameterRequest;
import com.oracle.bmc.oda.requests.DeleteSkillRequest;
import com.oracle.bmc.oda.requests.DeleteTranslatorRequest;
import com.oracle.bmc.oda.requests.ExportDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.ExportSkillRequest;
import com.oracle.bmc.oda.requests.GetAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.GetChannelRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantParameterRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.GetSkillParameterRequest;
import com.oracle.bmc.oda.requests.GetSkillRequest;
import com.oracle.bmc.oda.requests.GetTranslatorRequest;
import com.oracle.bmc.oda.requests.ImportBotRequest;
import com.oracle.bmc.oda.requests.ListAuthenticationProvidersRequest;
import com.oracle.bmc.oda.requests.ListChannelsRequest;
import com.oracle.bmc.oda.requests.ListDigitalAssistantParametersRequest;
import com.oracle.bmc.oda.requests.ListDigitalAssistantsRequest;
import com.oracle.bmc.oda.requests.ListSkillParametersRequest;
import com.oracle.bmc.oda.requests.ListSkillsRequest;
import com.oracle.bmc.oda.requests.ListTranslatorsRequest;
import com.oracle.bmc.oda.requests.PublishDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.PublishSkillRequest;
import com.oracle.bmc.oda.requests.RotateChannelKeysRequest;
import com.oracle.bmc.oda.requests.StartChannelRequest;
import com.oracle.bmc.oda.requests.StopChannelRequest;
import com.oracle.bmc.oda.requests.UpdateAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.UpdateChannelRequest;
import com.oracle.bmc.oda.requests.UpdateDigitalAssistantParameterRequest;
import com.oracle.bmc.oda.requests.UpdateDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.UpdateSkillParameterRequest;
import com.oracle.bmc.oda.requests.UpdateSkillRequest;
import com.oracle.bmc.oda.requests.UpdateTranslatorRequest;
import com.oracle.bmc.oda.responses.ConfigureDigitalAssistantParametersResponse;
import com.oracle.bmc.oda.responses.CreateAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.CreateChannelResponse;
import com.oracle.bmc.oda.responses.CreateDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.CreateSkillParameterResponse;
import com.oracle.bmc.oda.responses.CreateSkillResponse;
import com.oracle.bmc.oda.responses.CreateTranslatorResponse;
import com.oracle.bmc.oda.responses.DeleteAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.DeleteChannelResponse;
import com.oracle.bmc.oda.responses.DeleteDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.DeleteSkillParameterResponse;
import com.oracle.bmc.oda.responses.DeleteSkillResponse;
import com.oracle.bmc.oda.responses.DeleteTranslatorResponse;
import com.oracle.bmc.oda.responses.ExportDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.ExportSkillResponse;
import com.oracle.bmc.oda.responses.GetAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.GetChannelResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantParameterResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.GetSkillParameterResponse;
import com.oracle.bmc.oda.responses.GetSkillResponse;
import com.oracle.bmc.oda.responses.GetTranslatorResponse;
import com.oracle.bmc.oda.responses.ImportBotResponse;
import com.oracle.bmc.oda.responses.ListAuthenticationProvidersResponse;
import com.oracle.bmc.oda.responses.ListChannelsResponse;
import com.oracle.bmc.oda.responses.ListDigitalAssistantParametersResponse;
import com.oracle.bmc.oda.responses.ListDigitalAssistantsResponse;
import com.oracle.bmc.oda.responses.ListSkillParametersResponse;
import com.oracle.bmc.oda.responses.ListSkillsResponse;
import com.oracle.bmc.oda.responses.ListTranslatorsResponse;
import com.oracle.bmc.oda.responses.PublishDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.PublishSkillResponse;
import com.oracle.bmc.oda.responses.RotateChannelKeysResponse;
import com.oracle.bmc.oda.responses.StartChannelResponse;
import com.oracle.bmc.oda.responses.StopChannelResponse;
import com.oracle.bmc.oda.responses.UpdateAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.UpdateChannelResponse;
import com.oracle.bmc.oda.responses.UpdateDigitalAssistantParameterResponse;
import com.oracle.bmc.oda.responses.UpdateDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.UpdateSkillParameterResponse;
import com.oracle.bmc.oda.responses.UpdateSkillResponse;
import com.oracle.bmc.oda.responses.UpdateTranslatorResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementClient
extends BaseSyncClient
implements Management {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://digitalassistant-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagementAsyncClient.class);
    private final ManagementWaiters waiters;
    private final ManagementPaginators paginators;

    private ManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Management-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ManagementWaiters(executorService, this);
        this.paginators = new ManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ConfigureDigitalAssistantParametersResponse configureDigitalAssistantParameters(ConfigureDigitalAssistantParametersRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConfigureDigitalAssistantParametersDetails(), "configureDigitalAssistantParametersDetails is required");
        return (ConfigureDigitalAssistantParametersResponse)this.clientCall(request, ConfigureDigitalAssistantParametersResponse::builder).logger(LOG, "configureDigitalAssistantParameters").serviceDetails("Management", "ConfigureDigitalAssistantParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/ConfigureDigitalAssistantParameters").method(Method.POST).requestBuilder(ConfigureDigitalAssistantParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("configureDigitalAssistantParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ConfigureDigitalAssistantParametersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAuthenticationProviderResponse createAuthenticationProvider(CreateAuthenticationProviderRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAuthenticationProviderDetails(), "createAuthenticationProviderDetails is required");
        return (CreateAuthenticationProviderResponse)this.clientCall(request, CreateAuthenticationProviderResponse::builder).logger(LOG, "createAuthenticationProvider").serviceDetails("Management", "CreateAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/CreateAuthenticationProvider").method(Method.POST).requestBuilder(CreateAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AuthenticationProvider.class, CreateAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("Location", CreateAuthenticationProviderResponse.Builder::location).handleResponseHeaderString("etag", CreateAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAuthenticationProviderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateChannelDetails(), "createChannelDetails is required");
        return (CreateChannelResponse)this.clientCall(request, CreateChannelResponse::builder).logger(LOG, "createChannel").serviceDetails("Management", "CreateChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/CreateChannel").method(Method.POST).requestBuilder(CreateChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CreateChannelResult.class, CreateChannelResponse.Builder::createChannelResult).handleResponseHeaderString("Location", CreateChannelResponse.Builder::location).handleResponseHeaderString("etag", CreateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDigitalAssistantResponse createDigitalAssistant(CreateDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDigitalAssistantDetails(), "createDigitalAssistantDetails is required");
        return (CreateDigitalAssistantResponse)this.clientCall(request, CreateDigitalAssistantResponse::builder).logger(LOG, "createDigitalAssistant").serviceDetails("Management", "CreateDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/CreateDigitalAssistant").method(Method.POST).requestBuilder(CreateDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateDigitalAssistantResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDigitalAssistantResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSkillResponse createSkill(CreateSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSkillDetails(), "createSkillDetails is required");
        return (CreateSkillResponse)this.clientCall(request, CreateSkillResponse::builder).logger(LOG, "createSkill").serviceDetails("Management", "CreateSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/CreateSkill").method(Method.POST).requestBuilder(CreateSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSkillResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSkillResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSkillParameterResponse createSkillParameter(CreateSkillParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSkillParameterDetails(), "createSkillParameterDetails is required");
        return (CreateSkillParameterResponse)this.clientCall(request, CreateSkillParameterResponse::builder).logger(LOG, "createSkillParameter").serviceDetails("Management", "CreateSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/CreateSkillParameter").method(Method.POST).requestBuilder(CreateSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SkillParameter.class, CreateSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("Location", CreateSkillParameterResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateSkillParameterResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSkillParameterResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTranslatorResponse createTranslator(CreateTranslatorRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTranslatorDetails(), "createTranslatorDetails is required");
        return (CreateTranslatorResponse)this.clientCall(request, CreateTranslatorResponse::builder).logger(LOG, "createTranslator").serviceDetails("Management", "CreateTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/CreateTranslator").method(Method.POST).requestBuilder(CreateTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Translator.class, CreateTranslatorResponse.Builder::translator).handleResponseHeaderString("Location", CreateTranslatorResponse.Builder::location).handleResponseHeaderString("etag", CreateTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTranslatorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAuthenticationProviderResponse deleteAuthenticationProvider(DeleteAuthenticationProviderRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        return (DeleteAuthenticationProviderResponse)this.clientCall(request, DeleteAuthenticationProviderResponse::builder).logger(LOG, "deleteAuthenticationProvider").serviceDetails("Management", "DeleteAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/DeleteAuthenticationProvider").method(Method.DELETE).requestBuilder(DeleteAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAuthenticationProviderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (DeleteChannelResponse)this.clientCall(request, DeleteChannelResponse::builder).logger(LOG, "deleteChannel").serviceDetails("Management", "DeleteChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/DeleteChannel").method(Method.DELETE).requestBuilder(DeleteChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDigitalAssistantResponse deleteDigitalAssistant(DeleteDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return (DeleteDigitalAssistantResponse)this.clientCall(request, DeleteDigitalAssistantResponse::builder).logger(LOG, "deleteDigitalAssistant").serviceDetails("Management", "DeleteDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/DeleteDigitalAssistant").method(Method.DELETE).requestBuilder(DeleteDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDigitalAssistantResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSkillResponse deleteSkill(DeleteSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return (DeleteSkillResponse)this.clientCall(request, DeleteSkillResponse::builder).logger(LOG, "deleteSkill").serviceDetails("Management", "DeleteSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/DeleteSkill").method(Method.DELETE).requestBuilder(DeleteSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSkillResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSkillParameterResponse deleteSkillParameter(DeleteSkillParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return (DeleteSkillParameterResponse)this.clientCall(request, DeleteSkillParameterResponse::builder).logger(LOG, "deleteSkillParameter").serviceDetails("Management", "DeleteSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/DeleteSkillParameter").method(Method.DELETE).requestBuilder(DeleteSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSkillParameterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTranslatorResponse deleteTranslator(DeleteTranslatorRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        return (DeleteTranslatorResponse)this.clientCall(request, DeleteTranslatorResponse::builder).logger(LOG, "deleteTranslator").serviceDetails("Management", "DeleteTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/DeleteTranslator").method(Method.DELETE).requestBuilder(DeleteTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTranslatorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportDigitalAssistantResponse exportDigitalAssistant(ExportDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportDigitalAssistantDetails(), "exportDigitalAssistantDetails is required");
        return (ExportDigitalAssistantResponse)this.clientCall(request, ExportDigitalAssistantResponse::builder).logger(LOG, "exportDigitalAssistant").serviceDetails("Management", "ExportDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ExportDigitalAssistant").method(Method.POST).requestBuilder(ExportDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ExportDigitalAssistantResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportDigitalAssistantResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ExportSkillResponse exportSkill(ExportSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportSkillDetails(), "exportSkillDetails is required");
        return (ExportSkillResponse)this.clientCall(request, ExportSkillResponse::builder).logger(LOG, "exportSkill").serviceDetails("Management", "ExportSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ExportSkill").method(Method.POST).requestBuilder(ExportSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ExportSkillResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportSkillResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetAuthenticationProviderResponse getAuthenticationProvider(GetAuthenticationProviderRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        return (GetAuthenticationProviderResponse)this.clientCall(request, GetAuthenticationProviderResponse::builder).logger(LOG, "getAuthenticationProvider").serviceDetails("Management", "GetAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/GetAuthenticationProvider").method(Method.GET).requestBuilder(GetAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AuthenticationProvider.class, GetAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("etag", GetAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAuthenticationProviderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetChannelResponse getChannel(GetChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (GetChannelResponse)this.clientCall(request, GetChannelResponse::builder).logger(LOG, "getChannel").serviceDetails("Management", "GetChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/GetChannel").method(Method.GET).requestBuilder(GetChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Channel.class, GetChannelResponse.Builder::channel).handleResponseHeaderString("etag", GetChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDigitalAssistantResponse getDigitalAssistant(GetDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return (GetDigitalAssistantResponse)this.clientCall(request, GetDigitalAssistantResponse::builder).logger(LOG, "getDigitalAssistant").serviceDetails("Management", "GetDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/GetDigitalAssistant").method(Method.GET).requestBuilder(GetDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistant.class, GetDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", GetDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDigitalAssistantResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDigitalAssistantParameterResponse getDigitalAssistantParameter(GetDigitalAssistantParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return (GetDigitalAssistantParameterResponse)this.clientCall(request, GetDigitalAssistantParameterResponse::builder).logger(LOG, "getDigitalAssistantParameter").serviceDetails("Management", "GetDigitalAssistantParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/GetDigitalAssistantParameter").method(Method.GET).requestBuilder(GetDigitalAssistantParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantParameter.class, GetDigitalAssistantParameterResponse.Builder::digitalAssistantParameter).handleResponseHeaderString("etag", GetDigitalAssistantParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDigitalAssistantParameterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSkillResponse getSkill(GetSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return (GetSkillResponse)this.clientCall(request, GetSkillResponse::builder).logger(LOG, "getSkill").serviceDetails("Management", "GetSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/GetSkill").method(Method.GET).requestBuilder(GetSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Skill.class, GetSkillResponse.Builder::skill).handleResponseHeaderString("etag", GetSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSkillResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSkillParameterResponse getSkillParameter(GetSkillParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return (GetSkillParameterResponse)this.clientCall(request, GetSkillParameterResponse::builder).logger(LOG, "getSkillParameter").serviceDetails("Management", "GetSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/GetSkillParameter").method(Method.GET).requestBuilder(GetSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillParameter.class, GetSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("etag", GetSkillParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSkillParameterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTranslatorResponse getTranslator(GetTranslatorRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        return (GetTranslatorResponse)this.clientCall(request, GetTranslatorResponse::builder).logger(LOG, "getTranslator").serviceDetails("Management", "GetTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/GetTranslator").method(Method.GET).requestBuilder(GetTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Translator.class, GetTranslatorResponse.Builder::translator).handleResponseHeaderString("etag", GetTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTranslatorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportBotResponse importBot(ImportBotRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportBotDetails(), "importBotDetails is required");
        return (ImportBotResponse)this.clientCall(request, ImportBotResponse::builder).logger(LOG, "importBot").serviceDetails("Management", "ImportBot", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Bot/ImportBot").method(Method.POST).requestBuilder(ImportBotRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("importBot").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ImportBotResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportBotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAuthenticationProvidersResponse listAuthenticationProviders(ListAuthenticationProvidersRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return (ListAuthenticationProvidersResponse)this.clientCall(request, ListAuthenticationProvidersResponse::builder).logger(LOG, "listAuthenticationProviders").serviceDetails("Management", "ListAuthenticationProviders", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/ListAuthenticationProviders").method(Method.GET).requestBuilder(ListAuthenticationProvidersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("identityProvider", (BmcEnum)request.getIdentityProvider()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AuthenticationProviderCollection.class, ListAuthenticationProvidersResponse.Builder::authenticationProviderCollection).handleResponseHeaderString("opc-request-id", ListAuthenticationProvidersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAuthenticationProvidersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListAuthenticationProvidersResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return (ListChannelsResponse)this.clientCall(request, ListChannelsResponse::builder).logger(LOG, "listChannels").serviceDetails("Management", "ListChannels", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/ListChannels").method(Method.GET).requestBuilder(ListChannelsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("category", (BmcEnum)request.getCategory()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ChannelCollection.class, ListChannelsResponse.Builder::channelCollection).handleResponseHeaderString("opc-request-id", ListChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListChannelsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListChannelsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListDigitalAssistantParametersResponse listDigitalAssistantParameters(ListDigitalAssistantParametersRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return (ListDigitalAssistantParametersResponse)this.clientCall(request, ListDigitalAssistantParametersResponse::builder).logger(LOG, "listDigitalAssistantParameters").serviceDetails("Management", "ListDigitalAssistantParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/ListDigitalAssistantParameters").method(Method.GET).requestBuilder(ListDigitalAssistantParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantParameterCollection.class, ListDigitalAssistantParametersResponse.Builder::digitalAssistantParameterCollection).handleResponseHeaderString("opc-request-id", ListDigitalAssistantParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDigitalAssistantParametersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListDigitalAssistantParametersResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListDigitalAssistantsResponse listDigitalAssistants(ListDigitalAssistantsRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return (ListDigitalAssistantsResponse)this.clientCall(request, ListDigitalAssistantsResponse::builder).logger(LOG, "listDigitalAssistants").serviceDetails("Management", "ListDigitalAssistants", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/ListDigitalAssistants").method(Method.GET).requestBuilder(ListDigitalAssistantsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendQueryParam("digitalAssistantId", (Object)request.getDigitalAssistantId()).appendQueryParam("category", (Object)request.getCategory()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("namespace", (Object)request.getNamespace()).appendQueryParam("platformVersion", (Object)request.getPlatformVersion()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("lifecycleDetails", (Object)request.getLifecycleDetails()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantCollection.class, ListDigitalAssistantsResponse.Builder::digitalAssistantCollection).handleResponseHeaderString("opc-request-id", ListDigitalAssistantsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDigitalAssistantsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListDigitalAssistantsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListSkillParametersResponse listSkillParameters(ListSkillParametersRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return (ListSkillParametersResponse)this.clientCall(request, ListSkillParametersResponse::builder).logger(LOG, "listSkillParameters").serviceDetails("Management", "ListSkillParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/ListSkillParameters").method(Method.GET).requestBuilder(ListSkillParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillParameterCollection.class, ListSkillParametersResponse.Builder::skillParameterCollection).handleResponseHeaderString("opc-request-id", ListSkillParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSkillParametersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSkillParametersResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListSkillsResponse listSkills(ListSkillsRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return (ListSkillsResponse)this.clientCall(request, ListSkillsResponse::builder).logger(LOG, "listSkills").serviceDetails("Management", "ListSkills", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ListSkills").method(Method.GET).requestBuilder(ListSkillsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendQueryParam("skillId", (Object)request.getSkillId()).appendQueryParam("category", (Object)request.getCategory()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("namespace", (Object)request.getNamespace()).appendQueryParam("platformVersion", (Object)request.getPlatformVersion()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("lifecycleDetails", (Object)request.getLifecycleDetails()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillCollection.class, ListSkillsResponse.Builder::skillCollection).handleResponseHeaderString("opc-request-id", ListSkillsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSkillsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSkillsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public ListTranslatorsResponse listTranslators(ListTranslatorsRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return (ListTranslatorsResponse)this.clientCall(request, ListTranslatorsResponse::builder).logger(LOG, "listTranslators").serviceDetails("Management", "ListTranslators", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/ListTranslators").method(Method.GET).requestBuilder(ListTranslatorsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranslatorCollection.class, ListTranslatorsResponse.Builder::translatorCollection).handleResponseHeaderString("opc-request-id", ListTranslatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTranslatorsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListTranslatorsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public PublishDigitalAssistantResponse publishDigitalAssistant(PublishDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return (PublishDigitalAssistantResponse)this.clientCall(request, PublishDigitalAssistantResponse::builder).logger(LOG, "publishDigitalAssistant").serviceDetails("Management", "PublishDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/PublishDigitalAssistant").method(Method.POST).requestBuilder(PublishDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("actions").appendPathParam("publish").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistant.class, PublishDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", PublishDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PublishDigitalAssistantResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PublishSkillResponse publishSkill(PublishSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return (PublishSkillResponse)this.clientCall(request, PublishSkillResponse::builder).logger(LOG, "publishSkill").serviceDetails("Management", "PublishSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/PublishSkill").method(Method.POST).requestBuilder(PublishSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("actions").appendPathParam("publish").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Skill.class, PublishSkillResponse.Builder::skill).handleResponseHeaderString("etag", PublishSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PublishSkillResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RotateChannelKeysResponse rotateChannelKeys(RotateChannelKeysRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (RotateChannelKeysResponse)this.clientCall(request, RotateChannelKeysResponse::builder).logger(LOG, "rotateChannelKeys").serviceDetails("Management", "RotateChannelKeys", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/RotateChannelKeys").method(Method.POST).requestBuilder(RotateChannelKeysRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("rotateKeys").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(CreateChannelResult.class, RotateChannelKeysResponse.Builder::createChannelResult).handleResponseHeaderString("etag", RotateChannelKeysResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RotateChannelKeysResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartChannelResponse startChannel(StartChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (StartChannelResponse)this.clientCall(request, StartChannelResponse::builder).logger(LOG, "startChannel").serviceDetails("Management", "StartChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/StartChannel").method(Method.POST).requestBuilder(StartChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Channel.class, StartChannelResponse.Builder::channel).handleResponseHeaderString("etag", StartChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StartChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopChannelResponse stopChannel(StopChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return (StopChannelResponse)this.clientCall(request, StopChannelResponse::builder).logger(LOG, "stopChannel").serviceDetails("Management", "StopChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/StopChannel").method(Method.POST).requestBuilder(StopChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Channel.class, StopChannelResponse.Builder::channel).handleResponseHeaderString("etag", StopChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StopChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAuthenticationProviderResponse updateAuthenticationProvider(UpdateAuthenticationProviderRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAuthenticationProviderDetails(), "updateAuthenticationProviderDetails is required");
        return (UpdateAuthenticationProviderResponse)this.clientCall(request, UpdateAuthenticationProviderResponse::builder).logger(LOG, "updateAuthenticationProvider").serviceDetails("Management", "UpdateAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/UpdateAuthenticationProvider").method(Method.PUT).requestBuilder(UpdateAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AuthenticationProvider.class, UpdateAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("etag", UpdateAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAuthenticationProviderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateChannelDetails(), "updateChannelDetails is required");
        return (UpdateChannelResponse)this.clientCall(request, UpdateChannelResponse::builder).logger(LOG, "updateChannel").serviceDetails("Management", "UpdateChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/UpdateChannel").method(Method.PUT).requestBuilder(UpdateChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Channel.class, UpdateChannelResponse.Builder::channel).handleResponseHeaderString("etag", UpdateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDigitalAssistantResponse updateDigitalAssistant(UpdateDigitalAssistantRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDigitalAssistantDetails(), "updateDigitalAssistantDetails is required");
        return (UpdateDigitalAssistantResponse)this.clientCall(request, UpdateDigitalAssistantResponse::builder).logger(LOG, "updateDigitalAssistant").serviceDetails("Management", "UpdateDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/UpdateDigitalAssistant").method(Method.PUT).requestBuilder(UpdateDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DigitalAssistant.class, UpdateDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", UpdateDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDigitalAssistantResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDigitalAssistantParameterResponse updateDigitalAssistantParameter(UpdateDigitalAssistantParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDigitalAssistantParameterDetails(), "updateDigitalAssistantParameterDetails is required");
        return (UpdateDigitalAssistantParameterResponse)this.clientCall(request, UpdateDigitalAssistantParameterResponse::builder).logger(LOG, "updateDigitalAssistantParameter").serviceDetails("Management", "UpdateDigitalAssistantParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/UpdateDigitalAssistantParameter").method(Method.PUT).requestBuilder(UpdateDigitalAssistantParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DigitalAssistantParameter.class, UpdateDigitalAssistantParameterResponse.Builder::digitalAssistantParameter).handleResponseHeaderString("etag", UpdateDigitalAssistantParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDigitalAssistantParameterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSkillResponse updateSkill(UpdateSkillRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSkillDetails(), "updateSkillDetails is required");
        return (UpdateSkillResponse)this.clientCall(request, UpdateSkillResponse::builder).logger(LOG, "updateSkill").serviceDetails("Management", "UpdateSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/UpdateSkill").method(Method.PUT).requestBuilder(UpdateSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Skill.class, UpdateSkillResponse.Builder::skill).handleResponseHeaderString("etag", UpdateSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSkillResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSkillParameterResponse updateSkillParameter(UpdateSkillParameterRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSkillParameterDetails(), "updateSkillParameterDetails is required");
        return (UpdateSkillParameterResponse)this.clientCall(request, UpdateSkillParameterResponse::builder).logger(LOG, "updateSkillParameter").serviceDetails("Management", "UpdateSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/UpdateSkillParameter").method(Method.PUT).requestBuilder(UpdateSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SkillParameter.class, UpdateSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("etag", UpdateSkillParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSkillParameterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTranslatorResponse updateTranslator(UpdateTranslatorRequest request) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTranslatorDetails(), "updateTranslatorDetails is required");
        return (UpdateTranslatorResponse)this.clientCall(request, UpdateTranslatorResponse::builder).logger(LOG, "updateTranslator").serviceDetails("Management", "UpdateTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/UpdateTranslator").method(Method.PUT).requestBuilder(UpdateTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Translator.class, UpdateTranslatorResponse.Builder::translator).handleResponseHeaderString("etag", UpdateTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTranslatorResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagementClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

