/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.oda.ManagementAsync;
import com.oracle.bmc.oda.model.AuthenticationProvider;
import com.oracle.bmc.oda.model.AuthenticationProviderCollection;
import com.oracle.bmc.oda.model.Channel;
import com.oracle.bmc.oda.model.ChannelCollection;
import com.oracle.bmc.oda.model.CreateChannelResult;
import com.oracle.bmc.oda.model.DigitalAssistant;
import com.oracle.bmc.oda.model.DigitalAssistantCollection;
import com.oracle.bmc.oda.model.DigitalAssistantParameter;
import com.oracle.bmc.oda.model.DigitalAssistantParameterCollection;
import com.oracle.bmc.oda.model.Skill;
import com.oracle.bmc.oda.model.SkillCollection;
import com.oracle.bmc.oda.model.SkillParameter;
import com.oracle.bmc.oda.model.SkillParameterCollection;
import com.oracle.bmc.oda.model.Translator;
import com.oracle.bmc.oda.model.TranslatorCollection;
import com.oracle.bmc.oda.requests.ConfigureDigitalAssistantParametersRequest;
import com.oracle.bmc.oda.requests.CreateAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.CreateChannelRequest;
import com.oracle.bmc.oda.requests.CreateDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.CreateSkillParameterRequest;
import com.oracle.bmc.oda.requests.CreateSkillRequest;
import com.oracle.bmc.oda.requests.CreateTranslatorRequest;
import com.oracle.bmc.oda.requests.DeleteAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.DeleteChannelRequest;
import com.oracle.bmc.oda.requests.DeleteDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.DeleteSkillParameterRequest;
import com.oracle.bmc.oda.requests.DeleteSkillRequest;
import com.oracle.bmc.oda.requests.DeleteTranslatorRequest;
import com.oracle.bmc.oda.requests.ExportDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.ExportSkillRequest;
import com.oracle.bmc.oda.requests.GetAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.GetChannelRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantParameterRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.GetSkillParameterRequest;
import com.oracle.bmc.oda.requests.GetSkillRequest;
import com.oracle.bmc.oda.requests.GetTranslatorRequest;
import com.oracle.bmc.oda.requests.ImportBotRequest;
import com.oracle.bmc.oda.requests.ListAuthenticationProvidersRequest;
import com.oracle.bmc.oda.requests.ListChannelsRequest;
import com.oracle.bmc.oda.requests.ListDigitalAssistantParametersRequest;
import com.oracle.bmc.oda.requests.ListDigitalAssistantsRequest;
import com.oracle.bmc.oda.requests.ListSkillParametersRequest;
import com.oracle.bmc.oda.requests.ListSkillsRequest;
import com.oracle.bmc.oda.requests.ListTranslatorsRequest;
import com.oracle.bmc.oda.requests.PublishDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.PublishSkillRequest;
import com.oracle.bmc.oda.requests.RotateChannelKeysRequest;
import com.oracle.bmc.oda.requests.StartChannelRequest;
import com.oracle.bmc.oda.requests.StopChannelRequest;
import com.oracle.bmc.oda.requests.UpdateAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.UpdateChannelRequest;
import com.oracle.bmc.oda.requests.UpdateDigitalAssistantParameterRequest;
import com.oracle.bmc.oda.requests.UpdateDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.UpdateSkillParameterRequest;
import com.oracle.bmc.oda.requests.UpdateSkillRequest;
import com.oracle.bmc.oda.requests.UpdateTranslatorRequest;
import com.oracle.bmc.oda.responses.ConfigureDigitalAssistantParametersResponse;
import com.oracle.bmc.oda.responses.CreateAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.CreateChannelResponse;
import com.oracle.bmc.oda.responses.CreateDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.CreateSkillParameterResponse;
import com.oracle.bmc.oda.responses.CreateSkillResponse;
import com.oracle.bmc.oda.responses.CreateTranslatorResponse;
import com.oracle.bmc.oda.responses.DeleteAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.DeleteChannelResponse;
import com.oracle.bmc.oda.responses.DeleteDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.DeleteSkillParameterResponse;
import com.oracle.bmc.oda.responses.DeleteSkillResponse;
import com.oracle.bmc.oda.responses.DeleteTranslatorResponse;
import com.oracle.bmc.oda.responses.ExportDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.ExportSkillResponse;
import com.oracle.bmc.oda.responses.GetAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.GetChannelResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantParameterResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.GetSkillParameterResponse;
import com.oracle.bmc.oda.responses.GetSkillResponse;
import com.oracle.bmc.oda.responses.GetTranslatorResponse;
import com.oracle.bmc.oda.responses.ImportBotResponse;
import com.oracle.bmc.oda.responses.ListAuthenticationProvidersResponse;
import com.oracle.bmc.oda.responses.ListChannelsResponse;
import com.oracle.bmc.oda.responses.ListDigitalAssistantParametersResponse;
import com.oracle.bmc.oda.responses.ListDigitalAssistantsResponse;
import com.oracle.bmc.oda.responses.ListSkillParametersResponse;
import com.oracle.bmc.oda.responses.ListSkillsResponse;
import com.oracle.bmc.oda.responses.ListTranslatorsResponse;
import com.oracle.bmc.oda.responses.PublishDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.PublishSkillResponse;
import com.oracle.bmc.oda.responses.RotateChannelKeysResponse;
import com.oracle.bmc.oda.responses.StartChannelResponse;
import com.oracle.bmc.oda.responses.StopChannelResponse;
import com.oracle.bmc.oda.responses.UpdateAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.UpdateChannelResponse;
import com.oracle.bmc.oda.responses.UpdateDigitalAssistantParameterResponse;
import com.oracle.bmc.oda.responses.UpdateDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.UpdateSkillParameterResponse;
import com.oracle.bmc.oda.responses.UpdateSkillResponse;
import com.oracle.bmc.oda.responses.UpdateTranslatorResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementAsyncClient
extends BaseAsyncClient
implements ManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://digitalassistant-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagementAsyncClient.class);

    private ManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ConfigureDigitalAssistantParametersResponse> configureDigitalAssistantParameters(ConfigureDigitalAssistantParametersRequest request, AsyncHandler<ConfigureDigitalAssistantParametersRequest, ConfigureDigitalAssistantParametersResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConfigureDigitalAssistantParametersDetails(), "configureDigitalAssistantParametersDetails is required");
        return this.clientCall(request, ConfigureDigitalAssistantParametersResponse::builder).logger(LOG, "configureDigitalAssistantParameters").serviceDetails("Management", "ConfigureDigitalAssistantParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/ConfigureDigitalAssistantParameters").method(Method.POST).requestBuilder(ConfigureDigitalAssistantParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("configureDigitalAssistantParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ConfigureDigitalAssistantParametersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAuthenticationProviderResponse> createAuthenticationProvider(CreateAuthenticationProviderRequest request, AsyncHandler<CreateAuthenticationProviderRequest, CreateAuthenticationProviderResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAuthenticationProviderDetails(), "createAuthenticationProviderDetails is required");
        return this.clientCall(request, CreateAuthenticationProviderResponse::builder).logger(LOG, "createAuthenticationProvider").serviceDetails("Management", "CreateAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/CreateAuthenticationProvider").method(Method.POST).requestBuilder(CreateAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AuthenticationProvider.class, CreateAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("Location", CreateAuthenticationProviderResponse.Builder::location).handleResponseHeaderString("etag", CreateAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAuthenticationProviderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateChannelResponse> createChannel(CreateChannelRequest request, AsyncHandler<CreateChannelRequest, CreateChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateChannelDetails(), "createChannelDetails is required");
        return this.clientCall(request, CreateChannelResponse::builder).logger(LOG, "createChannel").serviceDetails("Management", "CreateChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/CreateChannel").method(Method.POST).requestBuilder(CreateChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CreateChannelResult.class, CreateChannelResponse.Builder::createChannelResult).handleResponseHeaderString("Location", CreateChannelResponse.Builder::location).handleResponseHeaderString("etag", CreateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDigitalAssistantResponse> createDigitalAssistant(CreateDigitalAssistantRequest request, AsyncHandler<CreateDigitalAssistantRequest, CreateDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDigitalAssistantDetails(), "createDigitalAssistantDetails is required");
        return this.clientCall(request, CreateDigitalAssistantResponse::builder).logger(LOG, "createDigitalAssistant").serviceDetails("Management", "CreateDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/CreateDigitalAssistant").method(Method.POST).requestBuilder(CreateDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateDigitalAssistantResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDigitalAssistantResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSkillResponse> createSkill(CreateSkillRequest request, AsyncHandler<CreateSkillRequest, CreateSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSkillDetails(), "createSkillDetails is required");
        return this.clientCall(request, CreateSkillResponse::builder).logger(LOG, "createSkill").serviceDetails("Management", "CreateSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/CreateSkill").method(Method.POST).requestBuilder(CreateSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSkillResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSkillResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSkillParameterResponse> createSkillParameter(CreateSkillParameterRequest request, AsyncHandler<CreateSkillParameterRequest, CreateSkillParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSkillParameterDetails(), "createSkillParameterDetails is required");
        return this.clientCall(request, CreateSkillParameterResponse::builder).logger(LOG, "createSkillParameter").serviceDetails("Management", "CreateSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/CreateSkillParameter").method(Method.POST).requestBuilder(CreateSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SkillParameter.class, CreateSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("Location", CreateSkillParameterResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateSkillParameterResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSkillParameterResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTranslatorResponse> createTranslator(CreateTranslatorRequest request, AsyncHandler<CreateTranslatorRequest, CreateTranslatorResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTranslatorDetails(), "createTranslatorDetails is required");
        return this.clientCall(request, CreateTranslatorResponse::builder).logger(LOG, "createTranslator").serviceDetails("Management", "CreateTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/CreateTranslator").method(Method.POST).requestBuilder(CreateTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Translator.class, CreateTranslatorResponse.Builder::translator).handleResponseHeaderString("Location", CreateTranslatorResponse.Builder::location).handleResponseHeaderString("etag", CreateTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTranslatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAuthenticationProviderResponse> deleteAuthenticationProvider(DeleteAuthenticationProviderRequest request, AsyncHandler<DeleteAuthenticationProviderRequest, DeleteAuthenticationProviderResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAuthenticationProviderResponse::builder).logger(LOG, "deleteAuthenticationProvider").serviceDetails("Management", "DeleteAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/DeleteAuthenticationProvider").method(Method.DELETE).requestBuilder(DeleteAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAuthenticationProviderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteChannelResponse> deleteChannel(DeleteChannelRequest request, AsyncHandler<DeleteChannelRequest, DeleteChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteChannelResponse::builder).logger(LOG, "deleteChannel").serviceDetails("Management", "DeleteChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/DeleteChannel").method(Method.DELETE).requestBuilder(DeleteChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDigitalAssistantResponse> deleteDigitalAssistant(DeleteDigitalAssistantRequest request, AsyncHandler<DeleteDigitalAssistantRequest, DeleteDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDigitalAssistantResponse::builder).logger(LOG, "deleteDigitalAssistant").serviceDetails("Management", "DeleteDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/DeleteDigitalAssistant").method(Method.DELETE).requestBuilder(DeleteDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDigitalAssistantResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSkillResponse> deleteSkill(DeleteSkillRequest request, AsyncHandler<DeleteSkillRequest, DeleteSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSkillResponse::builder).logger(LOG, "deleteSkill").serviceDetails("Management", "DeleteSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/DeleteSkill").method(Method.DELETE).requestBuilder(DeleteSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSkillResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSkillParameterResponse> deleteSkillParameter(DeleteSkillParameterRequest request, AsyncHandler<DeleteSkillParameterRequest, DeleteSkillParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSkillParameterResponse::builder).logger(LOG, "deleteSkillParameter").serviceDetails("Management", "DeleteSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/DeleteSkillParameter").method(Method.DELETE).requestBuilder(DeleteSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSkillParameterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTranslatorResponse> deleteTranslator(DeleteTranslatorRequest request, AsyncHandler<DeleteTranslatorRequest, DeleteTranslatorResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTranslatorResponse::builder).logger(LOG, "deleteTranslator").serviceDetails("Management", "DeleteTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/DeleteTranslator").method(Method.DELETE).requestBuilder(DeleteTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTranslatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportDigitalAssistantResponse> exportDigitalAssistant(ExportDigitalAssistantRequest request, AsyncHandler<ExportDigitalAssistantRequest, ExportDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportDigitalAssistantDetails(), "exportDigitalAssistantDetails is required");
        return this.clientCall(request, ExportDigitalAssistantResponse::builder).logger(LOG, "exportDigitalAssistant").serviceDetails("Management", "ExportDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ExportDigitalAssistant").method(Method.POST).requestBuilder(ExportDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ExportDigitalAssistantResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportDigitalAssistantResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportSkillResponse> exportSkill(ExportSkillRequest request, AsyncHandler<ExportSkillRequest, ExportSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportSkillDetails(), "exportSkillDetails is required");
        return this.clientCall(request, ExportSkillResponse::builder).logger(LOG, "exportSkill").serviceDetails("Management", "ExportSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ExportSkill").method(Method.POST).requestBuilder(ExportSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ExportSkillResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportSkillResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAuthenticationProviderResponse> getAuthenticationProvider(GetAuthenticationProviderRequest request, AsyncHandler<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAuthenticationProviderResponse::builder).logger(LOG, "getAuthenticationProvider").serviceDetails("Management", "GetAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/GetAuthenticationProvider").method(Method.GET).requestBuilder(GetAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AuthenticationProvider.class, GetAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("etag", GetAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAuthenticationProviderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetChannelResponse> getChannel(GetChannelRequest request, AsyncHandler<GetChannelRequest, GetChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetChannelResponse::builder).logger(LOG, "getChannel").serviceDetails("Management", "GetChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/GetChannel").method(Method.GET).requestBuilder(GetChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Channel.class, GetChannelResponse.Builder::channel).handleResponseHeaderString("etag", GetChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDigitalAssistantResponse> getDigitalAssistant(GetDigitalAssistantRequest request, AsyncHandler<GetDigitalAssistantRequest, GetDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDigitalAssistantResponse::builder).logger(LOG, "getDigitalAssistant").serviceDetails("Management", "GetDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/GetDigitalAssistant").method(Method.GET).requestBuilder(GetDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistant.class, GetDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", GetDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDigitalAssistantResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDigitalAssistantParameterResponse> getDigitalAssistantParameter(GetDigitalAssistantParameterRequest request, AsyncHandler<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDigitalAssistantParameterResponse::builder).logger(LOG, "getDigitalAssistantParameter").serviceDetails("Management", "GetDigitalAssistantParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/GetDigitalAssistantParameter").method(Method.GET).requestBuilder(GetDigitalAssistantParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantParameter.class, GetDigitalAssistantParameterResponse.Builder::digitalAssistantParameter).handleResponseHeaderString("etag", GetDigitalAssistantParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDigitalAssistantParameterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSkillResponse> getSkill(GetSkillRequest request, AsyncHandler<GetSkillRequest, GetSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSkillResponse::builder).logger(LOG, "getSkill").serviceDetails("Management", "GetSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/GetSkill").method(Method.GET).requestBuilder(GetSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Skill.class, GetSkillResponse.Builder::skill).handleResponseHeaderString("etag", GetSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSkillResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSkillParameterResponse> getSkillParameter(GetSkillParameterRequest request, AsyncHandler<GetSkillParameterRequest, GetSkillParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSkillParameterResponse::builder).logger(LOG, "getSkillParameter").serviceDetails("Management", "GetSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/GetSkillParameter").method(Method.GET).requestBuilder(GetSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillParameter.class, GetSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("etag", GetSkillParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSkillParameterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTranslatorResponse> getTranslator(GetTranslatorRequest request, AsyncHandler<GetTranslatorRequest, GetTranslatorResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTranslatorResponse::builder).logger(LOG, "getTranslator").serviceDetails("Management", "GetTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/GetTranslator").method(Method.GET).requestBuilder(GetTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Translator.class, GetTranslatorResponse.Builder::translator).handleResponseHeaderString("etag", GetTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTranslatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ImportBotResponse> importBot(ImportBotRequest request, AsyncHandler<ImportBotRequest, ImportBotResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportBotDetails(), "importBotDetails is required");
        return this.clientCall(request, ImportBotResponse::builder).logger(LOG, "importBot").serviceDetails("Management", "ImportBot", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Bot/ImportBot").method(Method.POST).requestBuilder(ImportBotRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("importBot").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ImportBotResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportBotResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAuthenticationProvidersResponse> listAuthenticationProviders(ListAuthenticationProvidersRequest request, AsyncHandler<ListAuthenticationProvidersRequest, ListAuthenticationProvidersResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAuthenticationProvidersResponse::builder).logger(LOG, "listAuthenticationProviders").serviceDetails("Management", "ListAuthenticationProviders", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/ListAuthenticationProviders").method(Method.GET).requestBuilder(ListAuthenticationProvidersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("identityProvider", (BmcEnum)request.getIdentityProvider()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AuthenticationProviderCollection.class, ListAuthenticationProvidersResponse.Builder::authenticationProviderCollection).handleResponseHeaderString("opc-request-id", ListAuthenticationProvidersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAuthenticationProvidersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListAuthenticationProvidersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListChannelsResponse> listChannels(ListChannelsRequest request, AsyncHandler<ListChannelsRequest, ListChannelsResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListChannelsResponse::builder).logger(LOG, "listChannels").serviceDetails("Management", "ListChannels", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/ListChannels").method(Method.GET).requestBuilder(ListChannelsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("category", (BmcEnum)request.getCategory()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ChannelCollection.class, ListChannelsResponse.Builder::channelCollection).handleResponseHeaderString("opc-request-id", ListChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListChannelsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListChannelsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDigitalAssistantParametersResponse> listDigitalAssistantParameters(ListDigitalAssistantParametersRequest request, AsyncHandler<ListDigitalAssistantParametersRequest, ListDigitalAssistantParametersResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDigitalAssistantParametersResponse::builder).logger(LOG, "listDigitalAssistantParameters").serviceDetails("Management", "ListDigitalAssistantParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/ListDigitalAssistantParameters").method(Method.GET).requestBuilder(ListDigitalAssistantParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantParameterCollection.class, ListDigitalAssistantParametersResponse.Builder::digitalAssistantParameterCollection).handleResponseHeaderString("opc-request-id", ListDigitalAssistantParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDigitalAssistantParametersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListDigitalAssistantParametersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDigitalAssistantsResponse> listDigitalAssistants(ListDigitalAssistantsRequest request, AsyncHandler<ListDigitalAssistantsRequest, ListDigitalAssistantsResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDigitalAssistantsResponse::builder).logger(LOG, "listDigitalAssistants").serviceDetails("Management", "ListDigitalAssistants", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/ListDigitalAssistants").method(Method.GET).requestBuilder(ListDigitalAssistantsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendQueryParam("digitalAssistantId", (Object)request.getDigitalAssistantId()).appendQueryParam("category", (Object)request.getCategory()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("namespace", (Object)request.getNamespace()).appendQueryParam("platformVersion", (Object)request.getPlatformVersion()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("lifecycleDetails", (Object)request.getLifecycleDetails()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistantCollection.class, ListDigitalAssistantsResponse.Builder::digitalAssistantCollection).handleResponseHeaderString("opc-request-id", ListDigitalAssistantsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDigitalAssistantsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListDigitalAssistantsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListSkillParametersResponse> listSkillParameters(ListSkillParametersRequest request, AsyncHandler<ListSkillParametersRequest, ListSkillParametersResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSkillParametersResponse::builder).logger(LOG, "listSkillParameters").serviceDetails("Management", "ListSkillParameters", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/ListSkillParameters").method(Method.GET).requestBuilder(ListSkillParametersRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillParameterCollection.class, ListSkillParametersResponse.Builder::skillParameterCollection).handleResponseHeaderString("opc-request-id", ListSkillParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSkillParametersResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSkillParametersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListSkillsResponse> listSkills(ListSkillsRequest request, AsyncHandler<ListSkillsRequest, ListSkillsResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSkillsResponse::builder).logger(LOG, "listSkills").serviceDetails("Management", "ListSkills", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/ListSkills").method(Method.GET).requestBuilder(ListSkillsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendQueryParam("skillId", (Object)request.getSkillId()).appendQueryParam("category", (Object)request.getCategory()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("namespace", (Object)request.getNamespace()).appendQueryParam("platformVersion", (Object)request.getPlatformVersion()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("lifecycleDetails", (Object)request.getLifecycleDetails()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SkillCollection.class, ListSkillsResponse.Builder::skillCollection).handleResponseHeaderString("opc-request-id", ListSkillsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSkillsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSkillsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTranslatorsResponse> listTranslators(ListTranslatorsRequest request, AsyncHandler<ListTranslatorsRequest, ListTranslatorsResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTranslatorsResponse::builder).logger(LOG, "listTranslators").serviceDetails("Management", "ListTranslators", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/ListTranslators").method(Method.GET).requestBuilder(ListTranslatorsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranslatorCollection.class, ListTranslatorsResponse.Builder::translatorCollection).handleResponseHeaderString("opc-request-id", ListTranslatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTranslatorsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListTranslatorsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<PublishDigitalAssistantResponse> publishDigitalAssistant(PublishDigitalAssistantRequest request, AsyncHandler<PublishDigitalAssistantRequest, PublishDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, PublishDigitalAssistantResponse::builder).logger(LOG, "publishDigitalAssistant").serviceDetails("Management", "PublishDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/PublishDigitalAssistant").method(Method.POST).requestBuilder(PublishDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("actions").appendPathParam("publish").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DigitalAssistant.class, PublishDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", PublishDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PublishDigitalAssistantResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PublishSkillResponse> publishSkill(PublishSkillRequest request, AsyncHandler<PublishSkillRequest, PublishSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, PublishSkillResponse::builder).logger(LOG, "publishSkill").serviceDetails("Management", "PublishSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/PublishSkill").method(Method.POST).requestBuilder(PublishSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("actions").appendPathParam("publish").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Skill.class, PublishSkillResponse.Builder::skill).handleResponseHeaderString("etag", PublishSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PublishSkillResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RotateChannelKeysResponse> rotateChannelKeys(RotateChannelKeysRequest request, AsyncHandler<RotateChannelKeysRequest, RotateChannelKeysResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RotateChannelKeysResponse::builder).logger(LOG, "rotateChannelKeys").serviceDetails("Management", "RotateChannelKeys", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/RotateChannelKeys").method(Method.POST).requestBuilder(RotateChannelKeysRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("rotateKeys").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(CreateChannelResult.class, RotateChannelKeysResponse.Builder::createChannelResult).handleResponseHeaderString("etag", RotateChannelKeysResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RotateChannelKeysResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartChannelResponse> startChannel(StartChannelRequest request, AsyncHandler<StartChannelRequest, StartChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartChannelResponse::builder).logger(LOG, "startChannel").serviceDetails("Management", "StartChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/StartChannel").method(Method.POST).requestBuilder(StartChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Channel.class, StartChannelResponse.Builder::channel).handleResponseHeaderString("etag", StartChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StartChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopChannelResponse> stopChannel(StopChannelRequest request, AsyncHandler<StopChannelRequest, StopChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopChannelResponse::builder).logger(LOG, "stopChannel").serviceDetails("Management", "StopChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/StopChannel").method(Method.POST).requestBuilder(StopChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Channel.class, StopChannelResponse.Builder::channel).handleResponseHeaderString("etag", StopChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StopChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAuthenticationProviderResponse> updateAuthenticationProvider(UpdateAuthenticationProviderRequest request, AsyncHandler<UpdateAuthenticationProviderRequest, UpdateAuthenticationProviderResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthenticationProviderId(), (String)"authenticationProviderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAuthenticationProviderDetails(), "updateAuthenticationProviderDetails is required");
        return this.clientCall(request, UpdateAuthenticationProviderResponse::builder).logger(LOG, "updateAuthenticationProvider").serviceDetails("Management", "UpdateAuthenticationProvider", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/AuthenticationProvider/UpdateAuthenticationProvider").method(Method.PUT).requestBuilder(UpdateAuthenticationProviderRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("authenticationProviders").appendPathParam(request.getAuthenticationProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AuthenticationProvider.class, UpdateAuthenticationProviderResponse.Builder::authenticationProvider).handleResponseHeaderString("etag", UpdateAuthenticationProviderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAuthenticationProviderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateChannelResponse> updateChannel(UpdateChannelRequest request, AsyncHandler<UpdateChannelRequest, UpdateChannelResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateChannelDetails(), "updateChannelDetails is required");
        return this.clientCall(request, UpdateChannelResponse::builder).logger(LOG, "updateChannel").serviceDetails("Management", "UpdateChannel", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Channel/UpdateChannel").method(Method.PUT).requestBuilder(UpdateChannelRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Channel.class, UpdateChannelResponse.Builder::channel).handleResponseHeaderString("etag", UpdateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDigitalAssistantResponse> updateDigitalAssistant(UpdateDigitalAssistantRequest request, AsyncHandler<UpdateDigitalAssistantRequest, UpdateDigitalAssistantResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDigitalAssistantDetails(), "updateDigitalAssistantDetails is required");
        return this.clientCall(request, UpdateDigitalAssistantResponse::builder).logger(LOG, "updateDigitalAssistant").serviceDetails("Management", "UpdateDigitalAssistant", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistant/UpdateDigitalAssistant").method(Method.PUT).requestBuilder(UpdateDigitalAssistantRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DigitalAssistant.class, UpdateDigitalAssistantResponse.Builder::digitalAssistant).handleResponseHeaderString("etag", UpdateDigitalAssistantResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDigitalAssistantResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDigitalAssistantParameterResponse> updateDigitalAssistantParameter(UpdateDigitalAssistantParameterRequest request, AsyncHandler<UpdateDigitalAssistantParameterRequest, UpdateDigitalAssistantParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDigitalAssistantId(), (String)"digitalAssistantId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDigitalAssistantParameterDetails(), "updateDigitalAssistantParameterDetails is required");
        return this.clientCall(request, UpdateDigitalAssistantParameterResponse::builder).logger(LOG, "updateDigitalAssistantParameter").serviceDetails("Management", "UpdateDigitalAssistantParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/DigitalAssistantParameter/UpdateDigitalAssistantParameter").method(Method.PUT).requestBuilder(UpdateDigitalAssistantParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("digitalAssistants").appendPathParam(request.getDigitalAssistantId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DigitalAssistantParameter.class, UpdateDigitalAssistantParameterResponse.Builder::digitalAssistantParameter).handleResponseHeaderString("etag", UpdateDigitalAssistantParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDigitalAssistantParameterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSkillResponse> updateSkill(UpdateSkillRequest request, AsyncHandler<UpdateSkillRequest, UpdateSkillResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSkillDetails(), "updateSkillDetails is required");
        return this.clientCall(request, UpdateSkillResponse::builder).logger(LOG, "updateSkill").serviceDetails("Management", "UpdateSkill", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Skill/UpdateSkill").method(Method.PUT).requestBuilder(UpdateSkillRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Skill.class, UpdateSkillResponse.Builder::skill).handleResponseHeaderString("etag", UpdateSkillResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSkillResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSkillParameterResponse> updateSkillParameter(UpdateSkillParameterRequest request, AsyncHandler<UpdateSkillParameterRequest, UpdateSkillParameterResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSkillId(), (String)"skillId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParameterName(), (String)"parameterName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSkillParameterDetails(), "updateSkillParameterDetails is required");
        return this.clientCall(request, UpdateSkillParameterResponse::builder).logger(LOG, "updateSkillParameter").serviceDetails("Management", "UpdateSkillParameter", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/SkillParameter/UpdateSkillParameter").method(Method.PUT).requestBuilder(UpdateSkillParameterRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("skills").appendPathParam(request.getSkillId()).appendPathParam("parameters").appendPathParam(request.getParameterName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SkillParameter.class, UpdateSkillParameterResponse.Builder::skillParameter).handleResponseHeaderString("etag", UpdateSkillParameterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSkillParameterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTranslatorResponse> updateTranslator(UpdateTranslatorRequest request, AsyncHandler<UpdateTranslatorRequest, UpdateTranslatorResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranslatorId(), (String)"translatorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTranslatorDetails(), "updateTranslatorDetails is required");
        return this.clientCall(request, UpdateTranslatorResponse::builder).logger(LOG, "updateTranslator").serviceDetails("Management", "UpdateTranslator", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/Translator/UpdateTranslator").method(Method.PUT).requestBuilder(UpdateTranslatorRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("translators").appendPathParam(request.getTranslatorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Translator.class, UpdateTranslatorResponse.Builder::translator).handleResponseHeaderString("etag", UpdateTranslatorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTranslatorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagementAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

