/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetEsxiHostRequest
extends BmcRequest<Void> {
    private String esxiHostId;
    private String opcRequestId;

    public String getEsxiHostId() {
        return this.esxiHostId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().esxiHostId(this.esxiHostId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",esxiHostId=").append(String.valueOf(this.esxiHostId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEsxiHostRequest)) {
            return false;
        }
        GetEsxiHostRequest other = (GetEsxiHostRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.esxiHostId, other.esxiHostId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.esxiHostId == null ? 43 : this.esxiHostId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEsxiHostRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String esxiHostId = null;
        private String opcRequestId = null;

        public Builder esxiHostId(String esxiHostId) {
            this.esxiHostId = esxiHostId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEsxiHostRequest o) {
            this.esxiHostId(o.getEsxiHostId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEsxiHostRequest build() {
            GetEsxiHostRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEsxiHostRequest buildWithoutInvocationCallback() {
            GetEsxiHostRequest request = new GetEsxiHostRequest();
            request.esxiHostId = this.esxiHostId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

