/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.ocvp.Sddc;
import com.oracle.bmc.ocvp.SddcAsyncClient;
import com.oracle.bmc.ocvp.SddcPaginators;
import com.oracle.bmc.ocvp.SddcWaiters;
import com.oracle.bmc.ocvp.model.SddcCollection;
import com.oracle.bmc.ocvp.model.SupportedHostShapeCollection;
import com.oracle.bmc.ocvp.model.SupportedSkuSummaryCollection;
import com.oracle.bmc.ocvp.model.SupportedVmwareSoftwareVersionCollection;
import com.oracle.bmc.ocvp.requests.CancelDowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.ChangeSddcCompartmentRequest;
import com.oracle.bmc.ocvp.requests.CreateSddcRequest;
import com.oracle.bmc.ocvp.requests.DeleteSddcRequest;
import com.oracle.bmc.ocvp.requests.DowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.GetSddcRequest;
import com.oracle.bmc.ocvp.requests.ListSddcsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedHostShapesRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedSkusRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedVmwareSoftwareVersionsRequest;
import com.oracle.bmc.ocvp.requests.RefreshHcxLicenseStatusRequest;
import com.oracle.bmc.ocvp.requests.UpdateSddcRequest;
import com.oracle.bmc.ocvp.requests.UpgradeHcxRequest;
import com.oracle.bmc.ocvp.responses.CancelDowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.ChangeSddcCompartmentResponse;
import com.oracle.bmc.ocvp.responses.CreateSddcResponse;
import com.oracle.bmc.ocvp.responses.DeleteSddcResponse;
import com.oracle.bmc.ocvp.responses.DowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.GetSddcResponse;
import com.oracle.bmc.ocvp.responses.ListSddcsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedHostShapesResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedSkusResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedVmwareSoftwareVersionsResponse;
import com.oracle.bmc.ocvp.responses.RefreshHcxLicenseStatusResponse;
import com.oracle.bmc.ocvp.responses.UpdateSddcResponse;
import com.oracle.bmc.ocvp.responses.UpgradeHcxResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SddcClient
extends BaseSyncClient
implements Sddc {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SDDC").serviceEndpointPrefix("").serviceEndpointTemplate("https://ocvps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SddcAsyncClient.class);
    private final SddcWaiters waiters;
    private final SddcPaginators paginators;

    private SddcClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Sddc-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new SddcWaiters(executorService, this);
        this.paginators = new SddcPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelDowngradeHcxResponse cancelDowngradeHcx(CancelDowngradeHcxRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (CancelDowngradeHcxResponse)this.clientCall(request, CancelDowngradeHcxResponse::builder).logger(LOG, "cancelDowngradeHcx").serviceDetails("Sddc", "CancelDowngradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/CancelDowngradeHcx").method(Method.POST).requestBuilder(CancelDowngradeHcxRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("cancelDowngradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", CancelDowngradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelDowngradeHcxResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeSddcCompartmentResponse changeSddcCompartment(ChangeSddcCompartmentRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSddcCompartmentDetails(), "changeSddcCompartmentDetails is required");
        return (ChangeSddcCompartmentResponse)this.clientCall(request, ChangeSddcCompartmentResponse::builder).logger(LOG, "changeSddcCompartment").serviceDetails("Sddc", "ChangeSddcCompartment", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/ChangeSddcCompartment").method(Method.POST).requestBuilder(ChangeSddcCompartmentRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSddcCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateSddcResponse createSddc(CreateSddcRequest request) {
        Objects.requireNonNull(request.getCreateSddcDetails(), "createSddcDetails is required");
        return (CreateSddcResponse)this.clientCall(request, CreateSddcResponse::builder).logger(LOG, "createSddc").serviceDetails("Sddc", "CreateSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/CreateSddc").method(Method.POST).requestBuilder(CreateSddcRequest::builder).basePath("/20200501").appendPathParam("sddcs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSddcResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSddcResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteSddcResponse deleteSddc(DeleteSddcRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (DeleteSddcResponse)this.clientCall(request, DeleteSddcResponse::builder).logger(LOG, "deleteSddc").serviceDetails("Sddc", "DeleteSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/DeleteSddc").method(Method.DELETE).requestBuilder(DeleteSddcRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteSddcResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSddcResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DowngradeHcxResponse downgradeHcx(DowngradeHcxRequest request) {
        Objects.requireNonNull(request.getDowngradeHcxDetails(), "downgradeHcxDetails is required");
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (DowngradeHcxResponse)this.clientCall(request, DowngradeHcxResponse::builder).logger(LOG, "downgradeHcx").serviceDetails("Sddc", "DowngradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/DowngradeHcx").method(Method.POST).requestBuilder(DowngradeHcxRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("downgradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", DowngradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DowngradeHcxResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSddcResponse getSddc(GetSddcRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (GetSddcResponse)this.clientCall(request, GetSddcResponse::builder).logger(LOG, "getSddc").serviceDetails("Sddc", "GetSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/GetSddc").method(Method.GET).requestBuilder(GetSddcRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.ocvp.model.Sddc.class, GetSddcResponse.Builder::sddc).handleResponseHeaderString("etag", GetSddcResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSddcResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSddcsResponse listSddcs(ListSddcsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSddcsResponse)this.clientCall(request, ListSddcsResponse::builder).logger(LOG, "listSddcs").serviceDetails("Sddc", "ListSddcs", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/SddcSummary/ListSddcs").method(Method.GET).requestBuilder(ListSddcsRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("computeAvailabilityDomain", (Object)request.getComputeAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SddcCollection.class, ListSddcsResponse.Builder::sddcCollection).handleResponseHeaderString("opc-request-id", ListSddcsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSddcsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSupportedHostShapesResponse listSupportedHostShapes(ListSupportedHostShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSupportedHostShapesResponse)this.clientCall(request, ListSupportedHostShapesResponse::builder).logger(LOG, "listSupportedHostShapes").serviceDetails("Sddc", "ListSupportedHostShapes", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapeSummary/ListSupportedHostShapes").method(Method.GET).requestBuilder(ListSupportedHostShapesRequest::builder).basePath("/20200501").appendPathParam("supportedHostShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sddcType", (BmcEnum)request.getSddcType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedHostShapeCollection.class, ListSupportedHostShapesResponse.Builder::supportedHostShapeCollection).handleResponseHeaderString("opc-request-id", ListSupportedHostShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedHostShapesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSupportedSkusResponse listSupportedSkus(ListSupportedSkusRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSupportedSkusResponse)this.clientCall(request, ListSupportedSkusResponse::builder).logger(LOG, "listSupportedSkus").serviceDetails("Sddc", "ListSupportedSkus", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus").method(Method.GET).requestBuilder(ListSupportedSkusRequest::builder).basePath("/20200501").appendPathParam("supportedSkus").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedSkuSummaryCollection.class, ListSupportedSkusResponse.Builder::supportedSkuSummaryCollection).handleResponseHeaderString("opc-request-id", ListSupportedSkusResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedSkusResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSupportedVmwareSoftwareVersionsResponse listSupportedVmwareSoftwareVersions(ListSupportedVmwareSoftwareVersionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSupportedVmwareSoftwareVersionsResponse)this.clientCall(request, ListSupportedVmwareSoftwareVersionsResponse::builder).logger(LOG, "listSupportedVmwareSoftwareVersions").serviceDetails("Sddc", "ListSupportedVmwareSoftwareVersions", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions").method(Method.GET).requestBuilder(ListSupportedVmwareSoftwareVersionsRequest::builder).basePath("/20200501").appendPathParam("supportedVmwareSoftwareVersions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedVmwareSoftwareVersionCollection.class, ListSupportedVmwareSoftwareVersionsResponse.Builder::supportedVmwareSoftwareVersionCollection).handleResponseHeaderString("opc-request-id", ListSupportedVmwareSoftwareVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedVmwareSoftwareVersionsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RefreshHcxLicenseStatusResponse refreshHcxLicenseStatus(RefreshHcxLicenseStatusRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (RefreshHcxLicenseStatusResponse)this.clientCall(request, RefreshHcxLicenseStatusResponse::builder).logger(LOG, "refreshHcxLicenseStatus").serviceDetails("Sddc", "RefreshHcxLicenseStatus", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/RefreshHcxLicenseStatus").method(Method.POST).requestBuilder(RefreshHcxLicenseStatusRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("refreshHcxLicenses").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", RefreshHcxLicenseStatusResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshHcxLicenseStatusResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateSddcResponse updateSddc(UpdateSddcRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSddcDetails(), "updateSddcDetails is required");
        return (UpdateSddcResponse)this.clientCall(request, UpdateSddcResponse::builder).logger(LOG, "updateSddc").serviceDetails("Sddc", "UpdateSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc").method(Method.PUT).requestBuilder(UpdateSddcRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.ocvp.model.Sddc.class, UpdateSddcResponse.Builder::sddc).handleResponseHeaderString("etag", UpdateSddcResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSddcResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpgradeHcxResponse upgradeHcx(UpgradeHcxRequest request) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return (UpgradeHcxResponse)this.clientCall(request, UpgradeHcxResponse::builder).logger(LOG, "upgradeHcx").serviceDetails("Sddc", "UpgradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpgradeHcx").method(Method.POST).requestBuilder(UpgradeHcxRequest::builder).basePath("/20200501").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("upgradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", UpgradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeHcxResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SddcWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SddcPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SddcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SddcClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SddcClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SddcClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SddcClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SddcClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SddcClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SddcClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

