/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ocvp.EsxiHost;
import com.oracle.bmc.ocvp.model.EsxiHostSummary;
import com.oracle.bmc.ocvp.requests.ListEsxiHostsRequest;
import com.oracle.bmc.ocvp.responses.ListEsxiHostsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EsxiHostPaginators {
    private final EsxiHost client;

    public EsxiHostPaginators(EsxiHost client) {
        this.client = client;
    }

    public Iterable<ListEsxiHostsResponse> listEsxiHostsResponseIterator(final ListEsxiHostsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEsxiHostsRequest.Builder>(){

            @Override
            public ListEsxiHostsRequest.Builder get() {
                return ListEsxiHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, String>(){

            @Override
            public String apply(ListEsxiHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEsxiHostsRequest.Builder>, ListEsxiHostsRequest>(){

            @Override
            public ListEsxiHostsRequest apply(RequestBuilderAndToken<ListEsxiHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEsxiHostsRequest, ListEsxiHostsResponse>(){

            @Override
            public ListEsxiHostsResponse apply(ListEsxiHostsRequest request) {
                return EsxiHostPaginators.this.client.listEsxiHosts(request);
            }
        });
    }

    public Iterable<EsxiHostSummary> listEsxiHostsRecordIterator(final ListEsxiHostsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEsxiHostsRequest.Builder>(){

            @Override
            public ListEsxiHostsRequest.Builder get() {
                return ListEsxiHostsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, String>(){

            @Override
            public String apply(ListEsxiHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEsxiHostsRequest.Builder>, ListEsxiHostsRequest>(){

            @Override
            public ListEsxiHostsRequest apply(RequestBuilderAndToken<ListEsxiHostsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEsxiHostsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEsxiHostsRequest, ListEsxiHostsResponse>(){

            @Override
            public ListEsxiHostsResponse apply(ListEsxiHostsRequest request) {
                return EsxiHostPaginators.this.client.listEsxiHosts(request);
            }
        }, (Function)new Function<ListEsxiHostsResponse, List<EsxiHostSummary>>(){

            @Override
            public List<EsxiHostSummary> apply(ListEsxiHostsResponse response) {
                return response.getEsxiHostCollection().getItems();
            }
        });
    }
}

