/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CancelWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String opcClientRequestId;

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelWorkRequestRequest)) {
            return false;
        }
        CancelWorkRequestRequest other = (CancelWorkRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelWorkRequestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workRequestId = null;
        private String opcClientRequestId = null;

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelWorkRequestRequest build() {
            CancelWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CancelWorkRequestRequest buildWithoutInvocationCallback() {
            CancelWorkRequestRequest request = new CancelWorkRequestRequest();
            request.workRequestId = this.workRequestId;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

