/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class UploadPartResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcContentMd5;
    private String eTag;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "opcContentMd5", "eTag"})
    UploadPartResponse(String opcClientRequestId, String opcRequestId, String opcContentMd5, String eTag) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcContentMd5 = opcContentMd5;
        this.eTag = eTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcContentMd5() {
        return this.opcContentMd5;
    }

    public String getETag() {
        return this.eTag;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcContentMd5;
        private String eTag;

        public Builder copy(UploadPartResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcContentMd5(o.getOpcContentMd5());
            this.eTag(o.getETag());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcContentMd5(String opcContentMd5) {
            this.opcContentMd5 = opcContentMd5;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public UploadPartResponse build() {
            return new UploadPartResponse(this.opcClientRequestId, this.opcRequestId, this.opcContentMd5, this.eTag);
        }

        public String toString() {
            return "UploadPartResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", opcContentMd5=" + this.opcContentMd5 + ", eTag=" + this.eTag + ")";
        }
    }
}

