/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.RetentionRule;
import java.beans.ConstructorProperties;

public class UpdateRetentionRuleResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String etag;
    private RetentionRule retentionRule;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "etag", "retentionRule"})
    UpdateRetentionRuleResponse(String opcClientRequestId, String opcRequestId, String etag, RetentionRule retentionRule) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.retentionRule = retentionRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public RetentionRule getRetentionRule() {
        return this.retentionRule;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String etag;
        private RetentionRule retentionRule;

        public Builder copy(UpdateRetentionRuleResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.retentionRule(o.getRetentionRule());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder retentionRule(RetentionRule retentionRule) {
            this.retentionRule = retentionRule;
            return this;
        }

        public UpdateRetentionRuleResponse build() {
            return new UpdateRetentionRuleResponse(this.opcClientRequestId, this.opcRequestId, this.etag, this.retentionRule);
        }

        public String toString() {
            return "UpdateRetentionRuleResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", retentionRule=" + this.retentionRule + ")";
        }
    }
}

