/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;
import java.util.Date;

public class RenameObjectResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private Date lastModified;
    private String versionId;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "eTag", "lastModified", "versionId"})
    RenameObjectResponse(String opcClientRequestId, String opcRequestId, String eTag, Date lastModified, String versionId) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.versionId = versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private Date lastModified;
        private String versionId;

        public Builder copy(RenameObjectResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.lastModified(o.getLastModified());
            this.versionId(o.getVersionId());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public RenameObjectResponse build() {
            return new RenameObjectResponse(this.opcClientRequestId, this.opcRequestId, this.eTag, this.lastModified, this.versionId);
        }

        public String toString() {
            return "RenameObjectResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", lastModified=" + this.lastModified + ", versionId=" + this.versionId + ")";
        }
    }
}

