/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ReplicationPolicySummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListReplicationPoliciesResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private String opcNextPage;
    private List<ReplicationPolicySummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcClientRequestId", "opcNextPage", "items"})
    ListReplicationPoliciesResponse(String opcRequestId, String opcClientRequestId, String opcNextPage, List<ReplicationPolicySummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<ReplicationPolicySummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcClientRequestId;
        private String opcNextPage;
        private List<ReplicationPolicySummary> items;

        public Builder copy(ListReplicationPoliciesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<ReplicationPolicySummary> items) {
            this.items = items;
            return this;
        }

        public ListReplicationPoliciesResponse build() {
            return new ListReplicationPoliciesResponse(this.opcRequestId, this.opcClientRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListReplicationPoliciesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

