/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ObjectVersionCollection;
import java.beans.ConstructorProperties;

public class ListObjectVersionsResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcNextPage;
    private ObjectVersionCollection objectVersionCollection;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "opcNextPage", "objectVersionCollection"})
    ListObjectVersionsResponse(String opcClientRequestId, String opcRequestId, String opcNextPage, ObjectVersionCollection objectVersionCollection) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.objectVersionCollection = objectVersionCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public ObjectVersionCollection getObjectVersionCollection() {
        return this.objectVersionCollection;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcNextPage;
        private ObjectVersionCollection objectVersionCollection;

        public Builder copy(ListObjectVersionsResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.objectVersionCollection(o.getObjectVersionCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder objectVersionCollection(ObjectVersionCollection objectVersionCollection) {
            this.objectVersionCollection = objectVersionCollection;
            return this;
        }

        public ListObjectVersionsResponse build() {
            return new ListObjectVersionsResponse(this.opcClientRequestId, this.opcRequestId, this.opcNextPage, this.objectVersionCollection);
        }

        public String toString() {
            return "ListObjectVersionsResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", objectVersionCollection=" + this.objectVersionCollection + ")";
        }
    }
}

