/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.BucketSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBucketsResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcNextPage;
    private List<BucketSummary> items;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "opcNextPage", "items"})
    ListBucketsResponse(String opcClientRequestId, String opcRequestId, String opcNextPage, List<BucketSummary> items) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<BucketSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcNextPage;
        private List<BucketSummary> items;

        public Builder copy(ListBucketsResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<BucketSummary> items) {
            this.items = items;
            return this;
        }

        public ListBucketsResponse build() {
            return new ListBucketsResponse(this.opcClientRequestId, this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListBucketsResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

