/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class HeadBucketResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private boolean isNotModified;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "eTag", "isNotModified"})
    HeadBucketResponse(String opcClientRequestId, String opcRequestId, String eTag, boolean isNotModified) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private boolean isNotModified;

        public Builder copy(HeadBucketResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.isNotModified(o.isNotModified());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public HeadBucketResponse build() {
            return new HeadBucketResponse(this.opcClientRequestId, this.opcRequestId, this.eTag, this.isNotModified);
        }

        public String toString() {
            return "HeadBucketResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", isNotModified=" + this.isNotModified + ")";
        }
    }
}

