/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.RetentionRule;
import java.beans.ConstructorProperties;
import java.util.Date;

public class GetRetentionRuleResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String etag;
    private Date lastModified;
    private RetentionRule retentionRule;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "etag", "lastModified", "retentionRule"})
    GetRetentionRuleResponse(String opcClientRequestId, String opcRequestId, String etag, Date lastModified, RetentionRule retentionRule) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.lastModified = lastModified;
        this.retentionRule = retentionRule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public RetentionRule getRetentionRule() {
        return this.retentionRule;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String etag;
        private Date lastModified;
        private RetentionRule retentionRule;

        public Builder copy(GetRetentionRuleResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.lastModified(o.getLastModified());
            this.retentionRule(o.getRetentionRule());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder retentionRule(RetentionRule retentionRule) {
            this.retentionRule = retentionRule;
            return this;
        }

        public GetRetentionRuleResponse build() {
            return new GetRetentionRuleResponse(this.opcClientRequestId, this.opcRequestId, this.etag, this.lastModified, this.retentionRule);
        }

        public String toString() {
            return "GetRetentionRuleResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", lastModified=" + this.lastModified + ", retentionRule=" + this.retentionRule + ")";
        }
    }
}

