/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import java.beans.ConstructorProperties;

public class GetPreauthenticatedRequestResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private PreauthenticatedRequestSummary preauthenticatedRequestSummary;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "preauthenticatedRequestSummary"})
    GetPreauthenticatedRequestResponse(String opcClientRequestId, String opcRequestId, PreauthenticatedRequestSummary preauthenticatedRequestSummary) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.preauthenticatedRequestSummary = preauthenticatedRequestSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PreauthenticatedRequestSummary getPreauthenticatedRequestSummary() {
        return this.preauthenticatedRequestSummary;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private PreauthenticatedRequestSummary preauthenticatedRequestSummary;

        public Builder copy(GetPreauthenticatedRequestResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.preauthenticatedRequestSummary(o.getPreauthenticatedRequestSummary());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder preauthenticatedRequestSummary(PreauthenticatedRequestSummary preauthenticatedRequestSummary) {
            this.preauthenticatedRequestSummary = preauthenticatedRequestSummary;
            return this;
        }

        public GetPreauthenticatedRequestResponse build() {
            return new GetPreauthenticatedRequestResponse(this.opcClientRequestId, this.opcRequestId, this.preauthenticatedRequestSummary);
        }

        public String toString() {
            return "GetPreauthenticatedRequestResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", preauthenticatedRequestSummary=" + this.preauthenticatedRequestSummary + ")";
        }
    }
}

