/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ObjectLifecyclePolicy;
import java.beans.ConstructorProperties;

public class GetObjectLifecyclePolicyResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private String eTag;
    private ObjectLifecyclePolicy objectLifecyclePolicy;

    @ConstructorProperties(value={"opcRequestId", "opcClientRequestId", "eTag", "objectLifecyclePolicy"})
    GetObjectLifecyclePolicyResponse(String opcRequestId, String opcClientRequestId, String eTag, ObjectLifecyclePolicy objectLifecyclePolicy) {
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.eTag = eTag;
        this.objectLifecyclePolicy = objectLifecyclePolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public ObjectLifecyclePolicy getObjectLifecyclePolicy() {
        return this.objectLifecyclePolicy;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcClientRequestId;
        private String eTag;
        private ObjectLifecyclePolicy objectLifecyclePolicy;

        public Builder copy(GetObjectLifecyclePolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.eTag(o.getETag());
            this.objectLifecyclePolicy(o.getObjectLifecyclePolicy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder objectLifecyclePolicy(ObjectLifecyclePolicy objectLifecyclePolicy) {
            this.objectLifecyclePolicy = objectLifecyclePolicy;
            return this;
        }

        public GetObjectLifecyclePolicyResponse build() {
            return new GetObjectLifecyclePolicyResponse(this.opcRequestId, this.opcClientRequestId, this.eTag, this.objectLifecyclePolicy);
        }

        public String toString() {
            return "GetObjectLifecyclePolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ", eTag=" + this.eTag + ", objectLifecyclePolicy=" + this.objectLifecyclePolicy + ")";
        }
    }
}

