/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;
import java.util.Date;

public class DeleteObjectResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private Date lastModified;
    private String versionId;
    private Boolean isDeleteMarker;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "lastModified", "versionId", "isDeleteMarker"})
    DeleteObjectResponse(String opcClientRequestId, String opcRequestId, Date lastModified, String versionId, Boolean isDeleteMarker) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.lastModified = lastModified;
        this.versionId = versionId;
        this.isDeleteMarker = isDeleteMarker;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Boolean getIsDeleteMarker() {
        return this.isDeleteMarker;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private Date lastModified;
        private String versionId;
        private Boolean isDeleteMarker;

        public Builder copy(DeleteObjectResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.lastModified(o.getLastModified());
            this.versionId(o.getVersionId());
            this.isDeleteMarker(o.getIsDeleteMarker());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder isDeleteMarker(Boolean isDeleteMarker) {
            this.isDeleteMarker = isDeleteMarker;
            return this;
        }

        public DeleteObjectResponse build() {
            return new DeleteObjectResponse(this.opcClientRequestId, this.opcRequestId, this.lastModified, this.versionId, this.isDeleteMarker);
        }

        public String toString() {
            return "DeleteObjectResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", lastModified=" + this.lastModified + ", versionId=" + this.versionId + ", isDeleteMarker=" + this.isDeleteMarker + ")";
        }
    }
}

