/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ReplicationPolicy;
import java.beans.ConstructorProperties;

public class CreateReplicationPolicyResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private ReplicationPolicy replicationPolicy;

    @ConstructorProperties(value={"opcRequestId", "opcClientRequestId", "replicationPolicy"})
    CreateReplicationPolicyResponse(String opcRequestId, String opcClientRequestId, ReplicationPolicy replicationPolicy) {
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.replicationPolicy = replicationPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcClientRequestId;
        private ReplicationPolicy replicationPolicy;

        public Builder copy(CreateReplicationPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.replicationPolicy(o.getReplicationPolicy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder replicationPolicy(ReplicationPolicy replicationPolicy) {
            this.replicationPolicy = replicationPolicy;
            return this;
        }

        public CreateReplicationPolicyResponse build() {
            return new CreateReplicationPolicyResponse(this.opcRequestId, this.opcClientRequestId, this.replicationPolicy);
        }

        public String toString() {
            return "CreateReplicationPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ", replicationPolicy=" + this.replicationPolicy + ")";
        }
    }
}

