/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.PreauthenticatedRequest;
import java.beans.ConstructorProperties;

public class CreatePreauthenticatedRequestResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private PreauthenticatedRequest preauthenticatedRequest;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "preauthenticatedRequest"})
    CreatePreauthenticatedRequestResponse(String opcClientRequestId, String opcRequestId, PreauthenticatedRequest preauthenticatedRequest) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.preauthenticatedRequest = preauthenticatedRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PreauthenticatedRequest getPreauthenticatedRequest() {
        return this.preauthenticatedRequest;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private PreauthenticatedRequest preauthenticatedRequest;

        public Builder copy(CreatePreauthenticatedRequestResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.preauthenticatedRequest(o.getPreauthenticatedRequest());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder preauthenticatedRequest(PreauthenticatedRequest preauthenticatedRequest) {
            this.preauthenticatedRequest = preauthenticatedRequest;
            return this;
        }

        public CreatePreauthenticatedRequestResponse build() {
            return new CreatePreauthenticatedRequestResponse(this.opcClientRequestId, this.opcRequestId, this.preauthenticatedRequest);
        }

        public String toString() {
            return "CreatePreauthenticatedRequestResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", preauthenticatedRequest=" + this.preauthenticatedRequest + ")";
        }
    }
}

