/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.MultipartUpload;
import java.beans.ConstructorProperties;

public class CreateMultipartUploadResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String location;
    private MultipartUpload multipartUpload;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "location", "multipartUpload"})
    CreateMultipartUploadResponse(String opcClientRequestId, String opcRequestId, String location, MultipartUpload multipartUpload) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.location = location;
        this.multipartUpload = multipartUpload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public MultipartUpload getMultipartUpload() {
        return this.multipartUpload;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String location;
        private MultipartUpload multipartUpload;

        public Builder copy(CreateMultipartUploadResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.location(o.getLocation());
            this.multipartUpload(o.getMultipartUpload());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder multipartUpload(MultipartUpload multipartUpload) {
            this.multipartUpload = multipartUpload;
            return this;
        }

        public CreateMultipartUploadResponse build() {
            return new CreateMultipartUploadResponse(this.opcClientRequestId, this.opcRequestId, this.location, this.multipartUpload);
        }

        public String toString() {
            return "CreateMultipartUploadResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", location=" + this.location + ", multipartUpload=" + this.multipartUpload + ")";
        }
    }
}

