/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class PutObjectRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private Long contentLength;
    private InputStream putObjectBody;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private String expect;
    private String contentMD5;
    private String contentType;
    private String contentLanguage;
    private String contentEncoding;
    private String contentDisposition;
    private String cacheControl;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private Map<String, String> opcMeta;

    @InternalSdk
    public InputStream getBody$() {
        return this.putObjectBody;
    }

    @ConstructorProperties(value={"namespaceName", "bucketName", "objectName", "contentLength", "putObjectBody", "ifMatch", "ifNoneMatch", "opcClientRequestId", "expect", "contentMD5", "contentType", "contentLanguage", "contentEncoding", "contentDisposition", "cacheControl", "opcSseCustomerAlgorithm", "opcSseCustomerKey", "opcSseCustomerKeySha256", "opcMeta"})
    PutObjectRequest(String namespaceName, String bucketName, String objectName, Long contentLength, InputStream putObjectBody, String ifMatch, String ifNoneMatch, String opcClientRequestId, String expect, String contentMD5, String contentType, String contentLanguage, String contentEncoding, String contentDisposition, String cacheControl, String opcSseCustomerAlgorithm, String opcSseCustomerKey, String opcSseCustomerKeySha256, Map<String, String> opcMeta) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.contentLength = contentLength;
        this.putObjectBody = putObjectBody;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.opcClientRequestId = opcClientRequestId;
        this.expect = expect;
        this.contentMD5 = contentMD5;
        this.contentType = contentType;
        this.contentLanguage = contentLanguage;
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.cacheControl = cacheControl;
        this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
        this.opcSseCustomerKey = opcSseCustomerKey;
        this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
        this.opcMeta = opcMeta;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getPutObjectBody() {
        return this.putObjectBody;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public Map<String, String> getOpcMeta() {
        return this.opcMeta;
    }

    public static class Builder
    implements BmcRequest.Builder<PutObjectRequest, InputStream> {
        private String namespaceName;
        private String bucketName;
        private String objectName;
        private Long contentLength;
        private InputStream putObjectBody;
        private String ifMatch;
        private String ifNoneMatch;
        private String opcClientRequestId;
        private String expect;
        private String contentMD5;
        private String contentType;
        private String contentLanguage;
        private String contentEncoding;
        private String contentDisposition;
        private String cacheControl;
        private String opcSseCustomerAlgorithm;
        private String opcSseCustomerKey;
        private String opcSseCustomerKeySha256;
        private Map<String, String> opcMeta;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.contentLength(o.getContentLength());
            this.putObjectBody(o.getPutObjectBody());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.expect(o.getExpect());
            this.contentMD5(o.getContentMD5());
            this.contentType(o.getContentType());
            this.contentLanguage(o.getContentLanguage());
            this.contentEncoding(o.getContentEncoding());
            this.contentDisposition(o.getContentDisposition());
            this.cacheControl(o.getCacheControl());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.opcMeta(o.getOpcMeta());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutObjectRequest build() {
            PutObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.putObjectBody(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder putObjectBody(InputStream putObjectBody) {
            this.putObjectBody = putObjectBody;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder opcMeta(Map<String, String> opcMeta) {
            this.opcMeta = opcMeta;
            return this;
        }

        public PutObjectRequest buildWithoutInvocationCallback() {
            return new PutObjectRequest(this.namespaceName, this.bucketName, this.objectName, this.contentLength, this.putObjectBody, this.ifMatch, this.ifNoneMatch, this.opcClientRequestId, this.expect, this.contentMD5, this.contentType, this.contentLanguage, this.contentEncoding, this.contentDisposition, this.cacheControl, this.opcSseCustomerAlgorithm, this.opcSseCustomerKey, this.opcSseCustomerKeySha256, this.opcMeta);
        }

        public String toString() {
            return "PutObjectRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", contentLength=" + this.contentLength + ", putObjectBody=" + this.putObjectBody + ", ifMatch=" + this.ifMatch + ", ifNoneMatch=" + this.ifNoneMatch + ", opcClientRequestId=" + this.opcClientRequestId + ", expect=" + this.expect + ", contentMD5=" + this.contentMD5 + ", contentType=" + this.contentType + ", contentLanguage=" + this.contentLanguage + ", contentEncoding=" + this.contentEncoding + ", contentDisposition=" + this.contentDisposition + ", cacheControl=" + this.cacheControl + ", opcSseCustomerAlgorithm=" + this.opcSseCustomerAlgorithm + ", opcSseCustomerKey=" + this.opcSseCustomerKey + ", opcSseCustomerKeySha256=" + this.opcSseCustomerKeySha256 + ", opcMeta=" + this.opcMeta + ")";
        }
    }
}

