/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetReplicationPolicyRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String replicationId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "replicationId", "opcClientRequestId"})
    GetReplicationPolicyRequest(String namespaceName, String bucketName, String replicationId, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.replicationId = replicationId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetReplicationPolicyRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private String replicationId;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetReplicationPolicyRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.replicationId(o.getReplicationId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetReplicationPolicyRequest build() {
            GetReplicationPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder replicationId(String replicationId) {
            this.replicationId = replicationId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public GetReplicationPolicyRequest buildWithoutInvocationCallback() {
            return new GetReplicationPolicyRequest(this.namespaceName, this.bucketName, this.replicationId, this.opcClientRequestId);
        }

        public String toString() {
            return "GetReplicationPolicyRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", replicationId=" + this.replicationId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

