/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreObjectsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreObjectsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RestoreObjectsRequest interceptRequest(RestoreObjectsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RestoreObjectsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRestoreObjectsDetails(), (String)"restoreObjectsDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("actions").path("restoreObjects");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, RestoreObjectsResponse> fromResponse() {
        Function<Response, RestoreObjectsResponse> transformer = new Function<Response, RestoreObjectsResponse>(){

            public RestoreObjectsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RestoreObjectsResponse.Builder builder = RestoreObjectsResponse.builder();
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RestoreObjectsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

